/****************************************************************************
 *                                                                          *
 * File    : ids.h                                                          *
 *                                                                          *
 * Purpose : Misc ID's for menus, strings, icons etc.                       *
 *                                                                          *
 * History : Date      Reason                                               *
 *           03-02-02  Created                                              *
 *                                                                          *
 ****************************************************************************/

#ifndef H_IDS
#define H_IDS

//
// String ID's --------------------------------------------------------------
//

#define IDS_NULL                        10001

#define IDS_BADSCREENRESOLUTION         10002   // 6.50
#define IDS_BADCOMCTLVERSION            10003
#define IDS_BADVERSION                  10004
#define IDS_OUTOFMEMORY                 10005
#define IDS_MEMORYERROR                 10006
#define IDS_COMMDLGERROR                10007
#define IDS_THREADERROR                 10008
#define IDS_DEBUGGERERROR               10009
#define IDS_EXECERROR                   10010
#define IDS_PIPEERROR                   10011
#define IDS_BADNUMBER                   10012
#define IDS_BACKUPERROR                 10013
#define IDS_CHANGEDIRERROR              10014
#define IDS_CREATEDIRERROR              10015
#define IDS_CREATEFILEERROR             10016
#define IDS_OPENFILEERROR               10017
#define IDS_READFILEERROR               10018
#define IDS_WRITEFILEERROR              10019
#define IDS_RENAMEFILEERROR             10020   // 4.0
#define IDS_DELETEFILEERROR             10021   // 5.0
#define IDS_WRITEREGERROR               10022
#define IDS_WRITEXMLERROR               10023   // 5.0
#define IDS_PRINTERROR                  10024
#define IDS_HELPERROR                   10025
#define IDS_OPENURLERROR                10026   // 7.0
#define IDS_SAVENOW                     10027
#define IDS_QUITNOW                     10028
#define IDS_MUSTRELOADNOW               10029
#define IDS_RESTOREBACKUP               10030
#define IDS_WRAPFINDATBOTTOM            10031
#define IDS_WRAPFINDATTOP               10032
#define IDS_REPLACECOMPLETE             10033
#define IDS_FINDTEXTERROR               10034
#define IDS_FINDFUNCERROR               10035
#define IDS_BADREGEX                    10036   // 11.0
#define IDS_BADDEVICECOLORS             10037
#define IDS_DELETEIMAGE                 10038
#define IDS_CANTEDITIMAGE               10039
#define IDS_BADDROPSHADOWIMAGE          10040   // 4.0
#define IDS_BADGIFSCREEN                10041   // 12.0
#define IDS_CREATECTRLERROR             10042
#define IDS_CREATEDLGERROR              10043
#define IDS_DUPCONTROLID                10044
#define IDS_DUPCONTROLMNEMONIC          10045
#define IDS_DUPPOPUPMNEMONIC            10046
#define IDS_NODUPMNEMONICS              10047
#define IDS_PASTEERROR                  10048
#define IDS_RESERVEDID                  10049
#define IDS_CREATERSRCERROR             10050
#define IDS_BADRESOURCENAME             10051
#define IDS_BADRESOURCETYPE             10052   // 3.0
#define IDS_DUPRSRCLANGUAGE             10053
#define IDS_LOADFORMERROR               10054
#define IDS_SAVEFORMERROR               10055
#define IDS_LOADMENUERROR               10056
#define IDS_SAVEMENUERROR               10057
#define IDS_LOADACCELERROR              10058
#define IDS_SAVEACCELERROR              10059
#define IDS_LOADTEXTERROR               10060
#define IDS_SAVETEXTERROR               10061
#define IDS_LOADMESSERROR               10062   // 3.0
#define IDS_SAVEMESSERROR               10063   // 3.0
#define IDS_LOADIMAGEERROR              10064
#define IDS_SAVEIMAGEERROR              10065
#define IDS_LOADANIMERROR               10066
#define IDS_SAVEANIMERROR               10067
#define IDS_LOADEDITERROR               10068
#define IDS_SAVEEDITERROR               10069
#define IDS_LOADVERSERROR               10070
#define IDS_SAVEVERSERROR               10071
#define IDS_LOADDUMPERROR               10072
#define IDS_SAVEDUMPERROR               10073
#define IDS_ENLARGEBITMAP               10074
#define IDS_SELECTPROJROOT              10075
#define IDS_SELECTFINDPATH              10076
#define IDS_UPGRADEPROJECT              10077   // 9.0
#define IDS_DUPPROJNAME                 10078
#define IDS_DELETEPROJECT               10079   // 4.0
#define IDS_IMPORTPROJECT               10080   // 4.0
#define IDS_IMPORTPROJFILE              10081
#define IDS_DELETEPROJFILE              10082
#define IDS_ADDPROJFILE                 10083
#define IDS_BADPROJPATH                 10084   // 7.0
#define IDS_BADPROJFILEPATH             10085   // 6.0
#define IDS_NOPROJMODE                  10086   // 11.0+
#define IDS_DUPPROJMODE                 10087   // 9.0
#define IDS_BADPROJMODENAME             10088   // 9.0
#define IDS_EXTRACTZIPERROR             10089
#define IDS_NOPROJZIPFILES              10090
#define IDS_NOPROJEXECUTOR              10091
#define IDS_DUPTEXTID                   10092
#define IDS_SETATTRIBERROR              10093
#define IDS_BADCOMPRESSION              10094
#define IDS_NEEDCERTIFICATE             10095   // 5.0
#define IDS_BADMACRONAME                10096
#define IDS_DUPMACRONAME                10097
#define IDS_NOMACROVALUE                10098   // 6.0
#define IDS_DUPCUSTCNTL                 10099
#define IDS_CANTLOADDLL                 10100
#define IDS_BADCUSTCNTL                 10101
#define IDS_CANTINITCUSTCNTL            10102
#define IDS_CUSTCNTLINUSE               10103
#define IDS_CUSTCNTLERROR               10104
#define IDS_BADLABELNAME                10105
#define IDS_DUPLABELS                   10106
#define IDS_DUPLABELID                  10107
#define IDS_DUPLABELNAME                10108
#define IDS_BADACCELKEY                 10109
#define IDS_BADSTRINGVALUE              10110
#define IDS_BADTOOLTEXT                 10111
#define IDS_BADTOOLCOMMAND              10112
#define IDS_BADTOOLMACRO                10113
#define IDS_BADHELPTEXT                 10114
#define IDS_BADHELPCOMMAND              10115
#define IDS_BADHELPBUILTIN              10116   // 7.0
#define IDS_BADSNIPPETNAME              10117   // 5.0
#define IDS_DUPSNIPPETNAME              10118   // 5.0
#define IDS_BADSNIPPETCODE              10119   // 5.0
#define IDS_SAVESNIPPETERROR            10120   // 5.0
#define IDS_DUPKEY                      10121
#define IDS_NODEBUGINFO                 10122
#define IDS_STOPDEBUGGER                10123
#define IDS_EXCEPTION1                  10124
#define IDS_EXCEPTION2                  10125
#define IDS_HARDWAREBREAK               10126   // 4.0
#define IDS_TIMESTAMPERROR              10127
#define IDS_BADBRKPNTLINE               10128
#define IDS_BADEXPRESSION               10129   // 4.0
#define IDS_NOBREAKCHAR                 10130
#define IDS_CFORMATERROR                10131   // 3.0
#define IDS_KILLPROCESS                 10132
//
#define IDS_FINDABORTED                 10133
#define IDS_FINDRESULT                  10134
#define IDS_NOFILETIME                  10135
#define IDS_FILESIZE                    10136
//
#define IDS_FILEPOPUP                   10137   // 7.0: IDS_TITLEFILE -> IDS_FILEPOPUP
#define IDS_EDITPOPUP                   10138   // 7.0
#define IDS_VIEWPOPUP                   10139   // 7.0: IDS_TITLEVIEW -> IDS_VIEWPOPUP
#define IDS_PROJPOPUP                   10140   // 7.0
#define IDS_TOOLPOPUP                   10141   // 7.0: IDS_TITLETOOLS -> IDS_TOOLPOPUP
#define IDS_WINPOPUP                    10142   // 7.0: IDS_TITLEWINDOWS -> IDS_WINPOPUP
#define IDS_HELPPOPUP                   10143   // 7.0: IDS_HELPTITLE -> IDS_HELPPOPUP
#define IDS_SRCPOPUP                    10144   // 7.0: IDS_EDITPOPUP -> IDS_SRCPOPUP
#define IDS_IMGPOPUP                    10145   // 7.0: IDS_PICTPOPUP -> IDS_IMGPOPUP
#define IDS_DLGPOPUP                    10146   // 7.0: IDS_FORMPOPUP -> IDS_DLGPOPUP
#define IDS_MENUPOPUP                   10147
#define IDS_MESSPOPUP                   10148   // 3.0
#define IDS_RSRCPOPUP                   10149
#define IDS_DBGPOPUP                    10150
#define IDS_WEBPOPUP                    10151   // 7.0
#define IDS_DIFFPOPUP                   10152   // 7.0
#define IDS_CUSTOMHELPPOPUP             10153   // 5.0
#define IDS_FILEFIND                    10154
#define IDS_STOPFILEFIND                10155   // 7.0: IDS_FILEFINDQUIT -> IDS_STOPFILEFIND
#define IDS_UNDOACTION                  10156
#define IDS_REDOACTION                  10157
#define IDS_BUILDPROJ                   10158
#define IDS_REBUILDPROJ                 10159   // 5.0
#define IDS_CLEANPROJ                   10160   // 9.0
#define IDS_BUILDWKSPROJ                10161   // 5.0
#define IDS_REBUILDWKSPROJ              10162   // 5.0
#define IDS_CLEANWKSPROJ                10163   // 9.0
#define IDS_STOPBUILD                   10164   // 5.0
#define IDS_COMPILEPROJ                 10165
#define IDS_EXECUTEPROJ                 10166
#define IDS_DEBUGPROJ                   10167
#define IDS_PROFILEPROJ                 10168   // 6.50
#define IDS_EXCLPROJ                    10169   // 4.0
#define IDS_INCLPROJ                    10170   // 4.0
#define IDS_FILEDIFF                    10171   // 7.0
#define IDS_STOPFILEDIFF                10172   // 7.0
#define IDS_TITLEENVIRONMENT            10173   // 10.0
#define IDS_TITLESETUP                  10174
#define IDS_TITLEPROJSETUP              10175   // 4.0
#define IDS_TITLECHOOSECOLOR            10176   // 4.0
#define IDS_TITLECUSTOMIZE              10177
#define IDS_TITLECUSTOM                 10178
#define IDS_TITLEMISC                   10179
#define IDS_TITLEDIFFERENCE             10180   // 7.0
#define IDS_TITLECURSOR                 10181
#define IDS_TITLEICON                   10182
#define IDS_TITLEBITMAP                 10183
#define IDS_TITLEMENU                   10184
#define IDS_TITLEDIALOG                 10185
#define IDS_TITLESTRINGTABLE            10186
#define IDS_TITLEACCELTABLE             10187
#define IDS_TITLEMSGTABLE               10188
#define IDS_TITLEVERSION                10189
#define IDS_TITLEANICURSOR              10190
#define IDS_TITLEANIICON                10191
#define IDS_TITLEHTML                   10192
#define IDS_TITLEXML                    10193
#define IDS_TITLEMANIFEST               10194
#define IDS_TITLERCDATA                 10195
#define IDS_TITLEVIDEO                  10196
#define IDS_TITLESOUND                  10197
#define IDS_TITLETYPELIB                10198
#define IDS_TITLEID                     10199
#define IDS_TITLETEXT                   10200
#define IDS_TITLEWORKSPACE              10201   // 4.0
#define IDS_TITLESOURCEFILES            10202
#define IDS_TITLEINCLUDEFILES           10203
#define IDS_TITLERESOURCEFILES          10204
#define IDS_TITLEOTHERFILES             10205
#define IDS_TITLEEXTERNALFILES          10206   // 8.0
#define IDS_TITLEFILENAME               10207
#define IDS_TITLEFILEPATH               10208
#define IDS_TITLEFILEDATE               10209
#define IDS_TITLELASTWRITETIME          10210
#define IDS_TITLEPROJECT                10211
#define IDS_TITLEFILEFIND               10212
#define IDS_TITLEDEBUGGER               10213   // 11.00
#define IDS_TITLEDEBUGGER_RUNNING       10214
#define IDS_TITLEDEBUGGER_STOPPED       10215
#define IDS_TITLEPROFILER_RUNNING       10216   // 6.50
#define IDS_TITLEPROFILER               10217   // 6.50
#define IDS_TITLETRACE                  10218
#define IDS_TITLEOUTPUT                 10219
#define IDS_TITLEAUTO                   10220
#define IDS_TITLELOCALS                 10221
#define IDS_TITLEGLOBALS                10222
#define IDS_TITLEREGISTERS              10223
#define IDS_TITLESTACK                  10224
#define IDS_TITLEMEMORY                 10225
#define IDS_TITLETHREADS                10226
#define IDS_TITLEMODULES                10227
#define IDS_TITLEEXCEPTIONS             10228
#define IDS_TITLEBREAKPOINTS            10229
#define IDS_TITLEWATCH                  10230
#define IDS_TITLETHREADID               10231
#define IDS_TITLEDESCRIPTION            10232   // 9.0
#define IDS_TITLESUSPENDED              10233
#define IDS_TITLEPRIORITY               10234
#define IDS_TITLEHWBREAKNOTHING         10235   // 4.0
#define IDS_TITLEHWBREAKWRITEONLY       10236   // 4.0
#define IDS_TITLEHWBREAKREADWRITE       10237   // 4.0
#define IDS_TITLEHWBREAK1BYTE           10238   // 4.0
#define IDS_TITLEHWBREAK2BYTE           10239   // 4.0
#define IDS_TITLEHWBREAK4BYTE           10240   // 4.0
#define IDS_TITLESTOPALWAYS             10241
#define IDS_TITLEBROWSESOURCE           10242
#define IDS_TITLESAMPLES                10243   // 6.50
#define IDS_TITLEPERCENT                10244   // 6.50
#define IDS_TITLEFUNCTION               10245   // 6.50
#define IDS_TITLEMODULENAME             10246   // 6.50
#define IDS_TITLESOURCEFILE             10247   // 6.50
#define IDS_TITLEINCLUSIVE              10248   // 8.0
#define IDS_TITLEEXCLUSIVE              10249   // 8.0
#define IDS_TITLEIMPORT                 10250
#define IDS_TITLEADDFILES               10251
#define IDS_TITLEADDPROJECTS            10252   // 4.0
#define IDS_TITLEFILEVERSION            10253
#define IDS_TITLEPRODUCTVERSION         10254
#define IDS_TITLEFILEFLAGSMASK          10255
#define IDS_TITLEFILEFLAGS              10256
#define IDS_TITLEFILEOS                 10257
#define IDS_TITLEFILETYPE               10258
#define IDS_TITLEFILESUBTYPE            10259
#define IDS_TITLEBLOCKHEADER            10260
#define IDS_TITLECOMMENTS               10261
#define IDS_TITLECOMPANYNAME            10262
#define IDS_TITLEFILEDESCRIPTION        10263
#define IDS_TITLEFILEVERSION2           10264
#define IDS_TITLEINTERNALNAME           10265
#define IDS_TITLECOPYRIGHT              10266
#define IDS_TITLETRADEMARKS             10267
#define IDS_TITLEORIGINALNAME           10268
#define IDS_TITLEPRIVATEBUILD           10269
#define IDS_TITLEPRODUCTNAME            10270
#define IDS_TITLEPRODUCTVERSION2        10271
#define IDS_TITLESPECIALBUILD           10272
#define IDS_TITLEALLFRAMES              10273
#define IDS_TITLESOMEFRAMES             10274
#define IDS_TITLEONEFRAME               10275
#define IDS_TITLEDRAWFRAME              10276   // 10.0: IDS_TITLEPICTFRAME -> IDS_TITLEDRAWFRAME
#define IDS_TITLEPATH                   10277
#define IDS_TITLELIB                    10278
#define IDS_TITLEINCLUDE                10279
#define IDS_TITLEPROPS                  10280
#define IDS_TITLENAME                   10281
#define IDS_TITLEVALUE                  10282
#define IDS_TITLEADDRESS                10283
#define IDS_TITLEDBGINFO                10284   // 8.0
#define IDS_TITLEDBGFILE                10285   // 12.0
#define IDS_TITLETYPE                   10286
#define IDS_TITLELINENO                 10287
#define IDS_TITLEADDMACRO               10288
#define IDS_TITLEEDITMACRO              10289
#define IDS_TITLEADDTOOL                10290
#define IDS_TITLEEDITTOOL               10291
#define IDS_TITLEADDHELP                10292
#define IDS_TITLEEDITHELP               10293
#define IDS_TITLEADDSNIPPET             10294   // 5.0
#define IDS_TITLEEDITSNIPPET            10295   // 5.0
#define IDS_TITLEKEY                    10296
#define IDS_TITLE1BPP                   10297
#define IDS_TITLE4BPP                   10298
#define IDS_TITLE8BPP                   10299
#define IDS_TITLE16BPP                  10300
#define IDS_TITLE24BPP                  10301
#define IDS_TITLE32BPP                  10302
#define IDS_TITLENONE                   10303
#define IDS_TITLEC                      10304
#define IDS_TITLEASM                    10305
#define IDS_TITLERC                     10306   // 6.0
#define IDS_TITLEMC                     10307   // 6.0
#define IDS_TITLEINST                   10308   // 5.0
#define IDS_TITLEDEF                    10309
#define IDS_TITLECUT                    10310
#define IDS_TITLECOPY                   10311
#define IDS_TITLEPASTE                  10312
#define IDS_TITLECLEAR                  10313
#define IDS_TITLEEDIT                   10314
#define IDS_TITLEINSERT                 10315
#define IDS_TITLEEFFECT                 10316
#define IDS_TITLEMIRROR                 10317
#define IDS_TITLEROTATE                 10318
#define IDS_TITLEGRAYSCALE              10319
#define IDS_TITLESEPIATONE              10320   // 4.0
#define IDS_TITLEOPAQUEALPHA            10321   // 4.0
#define IDS_TITLEHSV                    10322
#define IDS_TITLEDRAW                   10323
#define IDS_TITLESCREENCOLOR            10324
#define IDS_TITLERESIZE                 10325
#define IDS_TITLEALIGN                  10326
#define IDS_TITLEEVENSPACE              10327
#define IDS_TITLESIZETOTEXT             10328
#define IDS_TITLEMOVE                   10329
#define IDS_TITLECENTER                 10330
#define IDS_TITLEORDER                  10331
#define IDS_TITLECONVERT                10332
#define IDS_TITLEINDENT                 10333
#define IDS_TITLEREPLACE                10334
#define IDS_TITLEDRAGDROP               10335
#define IDS_TITLETEST                   10336   // 6.0
#define IDS_TITLEADVANCED               10337   // 6.0
#define IDS_TITLESTANDARD               10338   // 6.0
#define IDS_TITLEHELPCONTENTS           10339   // 7.0
#define IDS_TITLEHELPINDEX              10340   // 7.0
#define IDS_TITLEHELPSEARCH             10341   // 8.0
#define IDS_TITLEOUTLINE                10342   // 7.0
#define IDS_TITLEEXPAND                 10343   // 7.0
#define IDS_OPENINCLUDE                 10344   // 4.50
#define IDS_CONTEXTHELP                 10345
#define IDS_VIEWDEFINITION              10346
#define IDS_PREVDEFINITION              10347
#define IDS_FINDCALLSITES               10348   // 4.0
#define IDS_SURROUNDBY                  10349   // 5.0
#define IDS_EDITBREAKPOINT              10350   // 4.0
#define IDS_BREAKALWAYS                 10351   // 4.0
#define IDS_BREAKONHITCOUNT             10352   // 4.0
#define IDS_BREAKONEXPRESSION           10353   // 4.0
#define IDS_BREAKDISABLED               10354   // 4.0
#define IDS_APPNAME                     10355
#define IDS_APPVERSION                  10356
#define IDS_SPLASHVERSION               10357
#define IDS_DEBUGHELPER                 10358   // 8.0 (IDS_APPNAME_DBGHELPER -> IDS_APPNAME + IDS_DEBUGHELPER)
#define IDS_ADMINISTRATOR               10359   // 8.0
#define IDS_UNTITLED                    10360
#define IDS_OK                          10361   // 9.0
#define IDS_CANCEL                      10362   // 9.0
#define IDS_YES                         10363
#define IDS_NO                          10364
#define IDS_EMPTY                       10365
#define IDS_SPECIAL                     10366
#define IDS_NEUTRAL                     10367   // 8.0
#define IDS_SAMPLELINE                  10368
#define IDS_PRINTFILE                   10369
#define IDS_PRINTPAGE                   10370
#define IDS_OUTPUTDONE                  10371
#define IDS_DELETEFROMDISK              10372   // 9.0
#define IDS_DONTASKAGAIN                10373   // 9.0
#define IDS_GIFDISPOSALMETHOD0          10374   // 12.0
#define IDS_GIFDISPOSALMETHOD1          10375   // 12.0
#define IDS_GIFDISPOSALMETHOD2          10376   // 12.0
#define IDS_GIFDISPOSALMETHOD3          10377   // 12.0
//
#define IDS_COMMONFILTER                10378
#define IDS_SOURCEFILTER                10379
#define IDS_RESOURCEFILTER              10380
#define IDS_PROJECTFILTER               10381
#define IDS_IMAGEFILTER                 10382
#define IDS_ANIMATIONFILTER             10383
#define IDS_EXECUTEFILTER               10384
#define IDS_INSTALLFILTER               10385   // 5.0
#define IDS_IMPSRCFILTER                10386   // 4.0
#define IDS_IMPPROJFILTER               10387   // 4.0
#define IDS_IMPRSRCFILTER               10388
#define IDS_IMPANICURFILTER             10389
#define IDS_IMPAVIFILTER                10390
#define IDS_CUSTCNTLFILTER              10391
#define IDS_PALETTEFILTER               10392
#define IDS_CUSTTOOLFILTER              10393
#define IDS_CUSTHELPFILTER              10394
#define IDS_ALLFILTER                   10395
#define IDS_SRCFILTER                   10396
#define IDS_INCFILTER                   10397
#define IDS_HTMFILTER                   10398
#define IDS_XMLFILTER                   10399
#define IDS_DEFFILTER                   10400
#define IDS_PISFILTER                   10401   // 5.0
#define IDS_ASMFILTER                   10402
#define IDS_RCFILTER                    10403
#define IDS_RESFILTER                   10404
#define IDS_JPGFILTER                   10405
#define IDS_PNGFILTER                   10406
#define IDS_GIFFILTER                   10407
#define IDS_BMPFILTER                   10408
#define IDS_ICOFILTER                   10409
#define IDS_CURFILTER                   10410
#define IDS_ANICURFILTER                10411
#define IDS_AVIFILTER                   10412
#define IDS_ZIPFILTER                   10413
#define IDS_MSGFILTER                   10414   // 3.0
#define IDS_WAVFILTER                   10415   // 6.0
#define IDS_CEXT                        10416
#define IDS_HEXT                        10417
#define IDS_PPWEXT                      10418   // 4.0
#define IDS_PPJEXT                      10419
#define IDS_PPXEXT                      10420
#define IDS_TAGEXT                      10421
#define IDS_RCEXT                       10422
#define IDS_RESEXT                      10423
#define IDS_PCXEXT                      10424
#define IDS_GIFEXT                      10425
#define IDS_JPGEXT                      10426
#define IDS_PNGEXT                      10427
#define IDS_BMPEXT                      10428
#define IDS_DIBEXT                      10429
#define IDS_ICOEXT                      10430
#define IDS_CUREXT                      10431
#define IDS_ANIEXT                      10432
#define IDS_AVIEXT                      10433
#define IDS_PALEXT                      10434
#define IDS_CHMEXT                      10435
#define IDS_LIBEXT                      10436
#define IDS_DLLEXT                      10437
#define IDS_EXEEXT                      10438
#define IDS_OBJEXT                      10439
#define IDS_HTMEXT                      10440
#define IDS_XMLEXT                      10441
#define IDS_ZIPEXT                      10442
#define IDS_DEFEXT                      10443
#define IDS_ASMEXT                      10444
#define IDS_INCEXT                      10445
#define IDS_MCEXT                       10446   // 6.0
#define IDS_MSGEXT                      10447   // 3.0
#define IDS_PISEXT                      10448   // 5.0
#define IDS_TXTEXT                      10449   // 5.0
#define IDS_WAVEXT                      10450   // 6.0
#define IDS_DATEXT                      10451   // 8.0
#define IDS_OPENAUTO                    10452   // 4.50
#define IDS_OPENTEXT                    10453   // 4.50
#define IDS_OPENBINARY                  10454   // 4.50
#define IDS_OPENRESOURCE                10455   // 4.50
#define IDS_OPENRCDATA                  10456   // 4.50
#define IDS_OPENCUSTOM                  10457   // 4.50
//
#define IDS_STATEPOS                    10458
#define IDS_STATESIZE                   10459
#define IDS_STATEEDIT                   10460
#define IDS_STATEDEPSCAN                10461
#define IDS_STATEBROWSEINFO             10462   // 8.0
#define IDS_STATEPOPUP                  10463
#define IDS_STATESEPARATOR              10464
#define IDS_STATEMENUITEM               10465
#define IDS_STATEIMAGELIST              10466
#define IDS_STATEOILPAINT               10467
#define IDS_STATEDITHER                 10468
#define IDS_STATEZIP                    10469   // 7.0
#define IDS_STATELOADPROJ               10470   // 9.0
#define IDS_STATEINITPROJ               10471   // 10.0
#define IDS_FILEFINDWHAT                10472
#define IDS_DEFAULTMENUTEXT             10473
#define IDS_DONTMESS                    10474
#define IDS_SELECTFROMLIST              10475
#define IDS_TARGETNAME                  10476
#define IDS_TARGETBASENAME              10477
#define IDS_FIRSTPREQNAME               10478
#define IDS_ALLPREQNAMES                10479
//
#define IDS_DIALOGTEXT                  10480   // 5.0
#define IDS_TEXTTEXT                    10481   // 5.0
#define IDS_EDITBOXTEXT                 10482   // 5.0
#define IDS_GROUPBOXTEXT                10483   // 5.0
#define IDS_PUSHBUTTONTEXT              10484   // 5.0
#define IDS_CHECKBOXTEXT                10485   // 5.0
#define IDS_RADIOBUTTONTEXT             10486   // 5.0
#define IDS_RICHEDITTEXT                10487   // 5.0
#define IDS_SYSLINKTEXT                 10488   // 5.0
#define IDS_NETADDRESSTEXT              10489   // 5.0
#define IDS_SPLITBUTTONTEXT             10490   // 5.0
#define IDS_COMMANDLINKTEXT             10491   // 5.0
#define IDS_CUSTOMTEXT                  10492   // 5.0
//
#define IDS_UNUSED                      10493
#define IDS_IDOK                        10494
#define IDS_IDCANCEL                    10495
//
#define IDS_RCHEADER                    10496
#define IDS_HHEADER                     10497
//
#define IDS_ACCELSHIFT                  10498
#define IDS_ACCELCONTROL                10499
#define IDS_ACCELALT                    10500
//
#define IDS_MAKHEADER                   10501
#define IDS_MAKTARGET                   10502
#define IDS_DELETING                    10503   // 9.0
#define IDS_BUILDING                    10504
#define IDS_BUILDSKIPPED                10505   // 9.0
#define IDS_BUILDDONE                   10506
#define IDS_BUILDABORTED                10507
#define IDS_BUILDFAILURE                10508
#define IDS_BUILDBROWSEFAILURE          10509   // 6.0
#define IDS_BUILDMACROERROR             10510
#define IDS_BUILDERROR                  10511
#define IDS_BUILDERRORIGNORE            10512
#define IDS_BUILDERRORMSG               10513
#define IDS_PROJGRP_WIZARD              10514   // 4.50
#define IDS_PROJGRP_EMPTY               10515   // 4.50
#define IDS_PROJTYPE_W32APP             10516
#define IDS_PROJTYPE_W32DLL             10517
#define IDS_PROJTYPE_W32LIB             10518
#define IDS_PROJTYPE_W32CON             10519
#define IDS_PROJTYPE_W64APP             10520   // 5.0
#define IDS_PROJTYPE_W64DLL             10521   // 5.0
#define IDS_PROJTYPE_W64LIB             10522   // 5.0
#define IDS_PROJTYPE_W64CON             10523   // 5.0
#define IDS_PROJTYPE_W32INST            10524   // 5.0
#define IDS_WKSHEADER                   10525   // 4.0
//
#define IDS_CC_DIAGCLASSIC              10526   // 10.0
#define IDS_CC_DIAGCARET                10527   // 10.0
#define IDS_CC_WARNLEVEL0               10528
#define IDS_CC_WARNLEVEL1               10529
#define IDS_CC_WARNLEVEL2               10530
#define IDS_CC_OPTNONE                  10531
#define IDS_CC_OPTTIME                  10532
#define IDS_CC_OPTSIZE                  10533
#define IDS_CC_DEBUGNONE                10534
#define IDS_CC_DEBUGLINES               10535
#define IDS_CC_DEBUGFULL                10536
#define IDS_CC_CDECL                    10537
#define IDS_CC_STDCALL                  10538
#define IDS_CC_FASTCALL                 10539
#define IDS_CC_VECTORCALL               10540   // 10.0
#define IDS_CC_CRT                      10541
#define IDS_CC_CRTMT                    10542
#define IDS_CC_CRTDLL                   10543
#define IDS_CC_ARCH_SSE2                10544   // 9.0
#define IDS_CC_ARCH_AVX                 10545   // 9.0
#define IDS_CC_ARCH_AVX2                10546   // 9.0
#define IDS_CC_FPFAST                   10547   // 6.0
#define IDS_CC_FPPRECISE                10548   // 6.0
#define IDS_CC_INLINENONE               10549   // 6.0
#define IDS_CC_INLINEUSER               10550   // 6.0
#define IDS_CC_INLINEAUTO               10551   // 6.0
#define IDS_CC_C99                      10552   // 7.0
#define IDS_CC_C11                      10553   // 7.0
#define IDS_CC_C17                      10554   // 9.0
#define IDS_CC_C23                      10555   // 13.0
#define IDS_AS_DEBUGNONE                10556
#define IDS_AS_DEBUGLINES               10557
#define IDS_AS_DEBUGFULL                10558
#define IDS_AS_CDECL                    10559   // 4.50
#define IDS_AS_STDCALL                  10560   // 4.50
#define IDS_AS_FASTCALL                 10561   // 4.50
#define IDS_LD_DEBUGNONE                10562
#define IDS_LD_DEBUGPO                  10563   // 9.0: IDS_LD_DEBUGCV -> IDS_LD_DEBUGPO
#define IDS_LD_DEBUGCOFF                10564
#define IDS_LD_DEBUGBOTH                10565
#define IDS_LD_NATIVE                   10566
#define IDS_LD_CONSOLE                  10567
#define IDS_LD_WINDOWS                  10568
//
#define IDS_DBG_DONE                    10569
#define IDS_DBG_CREATEPROCESS           10570
#define IDS_DBG_CREATETHREAD            10571
#define IDS_DBG_LOADMODULE              10572
#define IDS_DBG_EXITPROCESS             10573
#define IDS_DBG_EXITTHREAD              10574
#define IDS_DBG_UNLOADMODULE            10575
#define IDS_DBG_RELOCATION              10576
#define IDS_DBG_LOADERROR               10577
#define IDS_DBG_BORLAND                 10578   // 4.0
#define IDS_DBG_BADEXPRESSION           10579   // 4.0
//
// Commands (custom keyboard).
//
#define IDS_FILE_NEWPROJECT             10580
#define IDS_FILE_NEWSOURCE              10581
#define IDS_FILE_NEWRESOURCE            10582
#define IDS_FILE_NEWBITMAP              10583
#define IDS_FILE_NEWICON                10584
#define IDS_FILE_NEWCURSOR              10585
#define IDS_FILE_NEWANICURSOR           10586
#define IDS_FILE_NEWVIDEO               10587
#define IDS_FILE_NEWHEXDUMP             10588
#define IDS_FILE_NEWMSGTABLE            10589   // 3.0
#define IDS_FILE_NEWWEB                 10590   // 7.0
#define IDS_FILE_NEWDIFF                10591   // 7.0
#define IDS_FILE_OPEN                   10592
#define IDS_FILE_CLOSE                  10593
#define IDS_FILE_CLOSEPROJ              10594   // 5.0
#define IDS_FILE_SAVE                   10595
#define IDS_FILE_SAVEAS                 10596
#define IDS_FILE_SAVEALL                10597
#define IDS_FILE_PRINT                  10598
#define IDS_FILE_PRINTSETUP             10599
#define IDS_FILE_PROPERTIES             10600
#define IDS_FILE_EXIT                   10601
//
#define IDS_EDIT_UNDO                   10602
#define IDS_EDIT_REDO                   10603
#define IDS_EDIT_CUT                    10604
#define IDS_EDIT_COPY                   10605
#define IDS_EDIT_PASTE                  10606
#define IDS_EDIT_INSERT                 10607
#define IDS_EDIT_DELETE                 10608
#define IDS_EDIT_DELETEWORD             10609
#define IDS_EDIT_SELECTALL              10610
#define IDS_EDIT_FIND                   10611
#define IDS_EDIT_FINDNEXT               10612
#define IDS_EDIT_REPLACE                10613
#define IDS_EDIT_FILEFIND               10614
#define IDS_EDIT_GOTO                   10615
//
#define IDS_VIEW_SHOWTOOLBAR            10616
#define IDS_VIEW_SHOWSTATUSBAR          10617
#define IDS_VIEW_SHOWDOCTABS            10618
#define IDS_VIEW_SHOWWELCOME            10619   // 7.0
#define IDS_VIEW_TOGGLEFULLSCREEN       10620   // 8.0
#define IDS_VIEW_SOURCEFILES            10621   // 5.0
#define IDS_VIEW_TARGETFILES            10622   // 5.0
//
#define IDS_PROJ_ADDFILE                10623
#define IDS_PROJ_ADDPROJECT             10624   // 4.0
#define IDS_PROJ_SETTINGS               10625
#define IDS_PROJ_MODES                  10626   // 9.0
#define IDS_PROJ_COMPILE                10627
#define IDS_PROJ_BUILD                  10628
#define IDS_PROJ_REBUILD                10629   // 5.0: IDS_PROJ_BUILDALL -> IDS_PROJ_REBUILD
#define IDS_PROJ_CLEAN                  10630   // 9.0
#define IDS_PROJ_BUILDWKS               10631   // 5.0
#define IDS_PROJ_REBUILDWKS             10632   // 5.0
#define IDS_PROJ_CLEANWKS               10633   // 9.0
#define IDS_PROJ_STOPBUILD              10634
#define IDS_PROJ_MAKEALLPREQS           10635
#define IDS_PROJ_EXECUTE                10636
#define IDS_PROJ_PROFILE                10637   // 6.50
#define IDS_PROJ_ZIP                    10638
#define IDS_PROJ_UNZIP                  10639
#define IDS_PROJ_SETACTIVE              10640   // 4.0
#define IDS_PROJ_DEPENDENCIES           10641   // 4.0
//
#define IDS_TOOL_CUSTOMIZE              10642
#define IDS_TOOL_SETTINGS               10643
#define IDS_TOOL_CUSTOMTOOL             10644
#define IDS_TOOL_CUSTOMTOOL_1           10645
#define IDS_TOOL_CUSTOMTOOL_2           10646
#define IDS_TOOL_CUSTOMTOOL_3           10647
#define IDS_TOOL_CUSTOMTOOL_4           10648
#define IDS_TOOL_CUSTOMTOOL_5           10649
#define IDS_TOOL_CUSTOMTOOL_6           10650
#define IDS_TOOL_CUSTOMTOOL_7           10651
#define IDS_TOOL_CUSTOMTOOL_8           10652   // 5.0
#define IDS_TOOL_CUSTOMTOOL_9           10653   // 5.0
#define IDS_TOOL_CUSTOMTOOL_10          10654   // 5.0
#define IDS_TOOL_CUSTOMTOOL_11          10655   // 5.0
#define IDS_TOOL_CUSTOMTOOL_12          10656   // 5.0
#define IDS_TOOL_CUSTOMTOOL_13          10657   // 5.0
#define IDS_TOOL_CUSTOMTOOL_14          10658   // 5.0
#define IDS_TOOL_CUSTOMTOOL_15          10659   // 5.0
//
#define IDS_WIN_NEW                     10660
#define IDS_WIN_CASCADE                 10661
#define IDS_WIN_TILEVERT                10662
#define IDS_WIN_TILEHORZ                10663
#define IDS_WIN_CLOSEALL                10664
//
#define IDS_HELP_CONTENTS               10665
#define IDS_HELP_ABOUT                  10666
#define IDS_HELP_CUSTOMHELP             10667
#define IDS_HELP_CUSTOMHELP_1           10668
#define IDS_HELP_CUSTOMHELP_2           10669
#define IDS_HELP_CUSTOMHELP_3           10670
#define IDS_HELP_CUSTOMHELP_4           10671
#define IDS_HELP_CUSTOMHELP_5           10672
#define IDS_HELP_CUSTOMHELP_6           10673
#define IDS_HELP_CUSTOMHELP_7           10674
#define IDS_HELP_CUSTOMHELP_8           10675   // 5.0
#define IDS_HELP_CUSTOMHELP_9           10676   // 5.0
#define IDS_HELP_CUSTOMHELP_10          10677   // 5.0
#define IDS_HELP_CUSTOMHELP_11          10678   // 5.0
#define IDS_HELP_CUSTOMHELP_12          10679   // 5.0
#define IDS_HELP_CUSTOMHELP_13          10680   // 5.0
#define IDS_HELP_CUSTOMHELP_14          10681   // 5.0
#define IDS_HELP_CUSTOMHELP_15          10682   // 5.0
//
#define IDS_IMG_NEWIMAGE                10683
#define IDS_IMG_DELETEIMAGE             10684
#define IDS_IMG_RESIZE                  10685   // 5.0
#define IDS_IMG_MIRROR_HORZ             10686
#define IDS_IMG_MIRROR_VERT             10687
#define IDS_IMG_ROTATE                  10688
#define IDS_IMG_GRAYSCALE               10689
#define IDS_IMG_SEPIATONE               10690   // 4.0
#define IDS_IMG_HSV                     10691
#define IDS_IMG_OPAQUEALPHA             10692   // 4.0
#define IDS_IMG_EFFECT_OILPAINT         10693
#define IDS_IMG_EFFECT_SPREAD           10694
#define IDS_IMG_EFFECT_EMBOSS           10695
#define IDS_IMG_EFFECT_FISHEYE          10696
#define IDS_IMG_EFFECT_DROPSHADOW       10697   // 4.0
#define IDS_IMG_EFFECT_BLUR             10698
#define IDS_IMG_EFFECT_SHARPEN          10699
//
#define IDS_DLG_NEWPICTURE              10700   // 4.50
#define IDS_DLG_NEWTEXT                 10701   // 4.50
#define IDS_DLG_NEWEDITBOX              10702   // 4.50
#define IDS_DLG_NEWGROUPBOX             10703   // 4.50
#define IDS_DLG_NEWPUSHBUTTON           10704   // 4.50
#define IDS_DLG_NEWCHECKBOX             10705   // 4.50
#define IDS_DLG_NEWRADIOBUTTON          10706   // 4.50
#define IDS_DLG_NEWCOMBOBOX             10707   // 4.50
#define IDS_DLG_NEWLISTBOX              10708   // 4.50
#define IDS_DLG_NEWHSCROLLBAR           10709   // 4.50
#define IDS_DLG_NEWVSCROLLBAR           10710   // 4.50
#define IDS_DLG_NEWUPDOWN               10711   // 4.50
#define IDS_DLG_NEWPROGRESS             10712   // 4.50
#define IDS_DLG_NEWTRACKBAR             10713   // 4.50
#define IDS_DLG_NEWHOTKEY               10714   // 4.50
#define IDS_DLG_NEWLISTVIEW             10715   // 4.50
#define IDS_DLG_NEWTREEVIEW             10716   // 4.50
#define IDS_DLG_NEWTABCONTROL           10717   // 4.50
#define IDS_DLG_NEWANIMATE              10718   // 4.50
#define IDS_DLG_NEWRICHEDIT             10719   // 4.50
#define IDS_DLG_NEWRICHED20             10720   // 4.50
#define IDS_DLG_NEWDATETIME             10721   // 4.50
#define IDS_DLG_NEWMONTHCAL             10722   // 4.50
#define IDS_DLG_NEWCOMBOBOXEX           10723   // 4.50
#define IDS_DLG_NEWREBAR                10724   // 4.50
#define IDS_DLG_NEWPAGER                10725   // 4.50
#define IDS_DLG_NEWTOOLBAR              10726   // 4.50
#define IDS_DLG_NEWSTATUSBAR            10727   // 4.50
#define IDS_DLG_NEWSYSLINK              10728   // 5.0
#define IDS_DLG_NEWIPADDRESS            10729   // 5.0
#define IDS_DLG_NEWNETADDRESS           10730   // 5.0
#define IDS_DLG_NEWSPLITBUTTON          10731   // 5.0
#define IDS_DLG_NEWCOMMANDLINK          10732   // 5.0
#define IDS_DLG_NEWNATIVEFONT           10733   // 5.0
#define IDS_DLG_ALIGNLEFT               10734
#define IDS_DLG_ALIGNVERT               10735
#define IDS_DLG_ALIGNRIGHT              10736
#define IDS_DLG_ALIGNTOP                10737
#define IDS_DLG_ALIGNHORZ               10738
#define IDS_DLG_ALIGNBOTTOM             10739
#define IDS_DLG_CENTERVERT              10740
#define IDS_DLG_CENTERHORZ              10741
#define IDS_DLG_SPACEVERT               10742
#define IDS_DLG_SPACEHORZ               10743
#define IDS_DLG_ARRSIZEWIDTH            10744
#define IDS_DLG_ARRSIZEHEIGHT           10745
#define IDS_DLG_ARRSIZEBOTH             10746
#define IDS_DLG_ARRPUSHBOTTOM           10747
#define IDS_DLG_ARRPUSHRIGHT            10748
#define IDS_DLG_SIZETOTEXT              10749
#define IDS_DLG_NEWCUSTOM               10750
#define IDS_DLG_OPENCUSTOM              10751
#define IDS_DLG_REMOVECUSTOM            10752
#define IDS_DLG_LOCKCONTROLS            10753
#define IDS_DLG_ORDERCONTROLS           10754
//
#define IDS_RSRC_NEWBITMAP              10755
#define IDS_RSRC_NEWICON                10756
#define IDS_RSRC_NEWCURSOR              10757
#define IDS_RSRC_NEWANICURSOR           10758
#define IDS_RSRC_NEWVIDEO               10759
#define IDS_RSRC_NEWDIALOG              10760
#define IDS_RSRC_NEWMENU                10761
#define IDS_RSRC_NEWSTRINGTABLE         10762
#define IDS_RSRC_NEWMSGTABLE            10763   // 3.0
#define IDS_RSRC_NEWACCEL               10764
#define IDS_RSRC_NEWVERSION             10765
#define IDS_RSRC_NEWMANIFEST            10766
#define IDS_RSRC_NEWHTML                10767   // 5.0
#define IDS_RSRC_NEWCUSTOM              10768   // 3.0
#define IDS_RSRC_NEWCOPY                10769
#define IDS_RSRC_IMPORT                 10770
#define IDS_RSRC_EXPORT                 10771   // 6.0
#define IDS_RSRC_SORTNAMES              10772
#define IDS_RSRC_LABELS                 10773   // 6.50: IDS_VIEW_LABELS -> IDS_RSRC_LABELS
#define IDS_RSRC_INCLUDES               10774   // 6.50: IDS_VIEW_INCLUDES -> IDS_RSRC_INCLUDES
//
#define IDS_MESS_SETINCLUDE             10775   // 3.0
#define IDS_MESS_VIEWLABELS             10776   // 3.0
//
#define IDS_SRC_FORCECALLTIP            10777   // 4.50
#define IDS_SRC_COMPLETEWORD            10778
#define IDS_SRC_INSERTSNIPPET           10779   // 5.0
#define IDS_SRC_SURROUNDBY              10780   // 5.0
#define IDS_SRC_SURROUNDBY_1            10781   // 5.0
#define IDS_SRC_SURROUNDBY_2            10782   // 5.0
#define IDS_SRC_SURROUNDBY_3            10783   // 5.0
#define IDS_SRC_SURROUNDBY_4            10784   // 5.0
#define IDS_SRC_SURROUNDBY_5            10785   // 5.0
#define IDS_SRC_SURROUNDBY_6            10786   // 5.0
#define IDS_SRC_SURROUNDBY_7            10787   // 5.0
#define IDS_SRC_SURROUNDBY_8            10788   // 5.0
#define IDS_SRC_SURROUNDBY_9            10789   // 5.0
#define IDS_SRC_SURROUNDBY_10           10790   // 5.0
#define IDS_SRC_SURROUNDBY_11           10791   // 5.0
#define IDS_SRC_SURROUNDBY_12           10792   // 5.0
#define IDS_SRC_SURROUNDBY_13           10793   // 5.0
#define IDS_SRC_SURROUNDBY_14           10794   // 5.0
#define IDS_SRC_SURROUNDBY_15           10795   // 5.0
#define IDS_SRC_UCASE                   10796
#define IDS_SRC_LCASE                   10797
#define IDS_SRC_TABTOSPACE              10798
#define IDS_SRC_SPACETOTAB              10799
#define IDS_SRC_FORMAT                  10800   // 3.0
#define IDS_SRC_COMMENT                 10801   // 4.0
#define IDS_SRC_UNCOMMENT               10802   // 4.0
#define IDS_SRC_NEXTBOOKMARK            10803
#define IDS_SRC_PREVBOOKMARK            10804
#define IDS_SRC_SETBOOKMARK             10805
#define IDS_SRC_CLEARBOOKMARKS          10806
#define IDS_SRC_WHITESPACE              10807
#define IDS_SRC_LINEBREAKS              10808
#define IDS_SRC_LINENUMBERS             10809
#define IDS_SRC_FOLDINGS                10810
#define IDS_SRC_MATCHINGBRACES          10811   // 4.50
#define IDS_SRC_VIEWDEFINITION          10812   // 6.0
#define IDS_SRC_PREVDEFINITION          10813   // 6.0
#define IDS_SRC_FOLDALL                 10814
#define IDS_SRC_UNFOLDALL               10815
//
#define IDS_DBG_GO                      10816
#define IDS_DBG_RESTART                 10817
#define IDS_DBG_STOP                    10818
#define IDS_DBG_BREAK                   10819
#define IDS_DBG_STEPINTO                10820
#define IDS_DBG_STEPOVER                10821
#define IDS_DBG_STEPOUT                 10822   // 4.0
#define IDS_DBG_RUNTOCURSOR             10823   // 4.0
#define IDS_DBG_TOGGLEBREAKPOINT        10824   // 4.0
#define IDS_DBG_SHOWNEXTSTMT            10825
#define IDS_DBG_ADDWATCH                10826
#define IDS_DBG_QUICKWATCH              10827   // 4.0
#define IDS_DBG_HWBREAKS                10828   // 4.0 B4
//
#define IDS_WEB_BACK                    10829   // 7.0
#define IDS_WEB_FORWARD                 10830   // 7.0
#define IDS_WEB_HOME                    10831   // 8.0
#define IDS_WEB_REFRESH                 10832   // 7.0
#define IDS_WEB_CERTIFICATE             10833   // 7.0
#define IDS_WEB_SHOWSOURCE              10834   // 7.0
//
#define IDS_DIFF_PREVCHANGE             10835   // 7.0
#define IDS_DIFF_NEXTCHANGE             10836   // 7.0
#define IDS_DIFF_REFRESH                10837   // 7.0
#define IDS_DIFF_OPENLEFT               10838   // 7.0
#define IDS_DIFF_OPENRIGHT              10839   // 7.0
#define IDS_DIFF_OPENCOMPOSITE          10840   // 9.0
//
#define IDS_MISC_OPEN                   10841
#define IDS_MISC_TEST                   10842
#define IDS_MISC_CHECKMNEMONICS         10843
#define IDS_MISC_NEXTWINDOW             10844
//
// Tooltips.
//
#define IDS_TIP_NEW                     10845
#define IDS_TIP_OPEN                    10846
#define IDS_TIP_SAVE                    10847
#define IDS_TIP_SAVEALL                 10848
#define IDS_TIP_CUT                     10849
#define IDS_TIP_COPY                    10850
#define IDS_TIP_PASTE                   10851
#define IDS_TIP_UNDO                    10852
#define IDS_TIP_REDO                    10853
#define IDS_TIP_COMPILE                 10854
#define IDS_TIP_BUILD                   10855
#define IDS_TIP_SETTINGS                10856   // 8.0
#define IDS_TIP_MAKEALLPREQS            10857   // 11.0
#define IDS_TIP_EXECUTE                 10858
#define IDS_TIP_GO                      10859
#define IDS_TIP_RESTART                 10860
#define IDS_TIP_STOPDEBUG               10861   // 7.0: IDS_TIP_STOP -> IDS_TIP_STOPDEBUG
#define IDS_TIP_STEPINTO                10862
#define IDS_TIP_STEPOVER                10863
#define IDS_TIP_STEPOUT                 10864   // 4.0
#define IDS_TIP_QUICKWATCH              10865   // 4.0
#define IDS_TIP_DELETE                  10866
#define IDS_TIP_CHECKMNEMONICS          10867
//
#define IDS_TIP_PENCIL                  10868
#define IDS_TIP_BRUSH                   10869
#define IDS_TIP_SELECT                  10870
#define IDS_TIP_PICKCOLOR               10871
#define IDS_TIP_LINE                    10872
#define IDS_TIP_RECT                    10873
#define IDS_TIP_ELLIPSE                 10874   // 4.0 (renamed)
#define IDS_TIP_ROUNDRECT               10875
#define IDS_TIP_DRAWTEXT                10876
#define IDS_TIP_FLOODFILL               10877
#define IDS_TIP_SPRAY                   10878
#define IDS_TIP_ERASER                  10879
#define IDS_TIP_MAGNIFY                 10880
#define IDS_TIP_HOTSPOT                 10881
#define IDS_TIP_GRADIENT                10882   // 5.0
#define IDS_TIP_LEFTCOLOR               10883
#define IDS_TIP_RIGHTCOLOR              10884
#define IDS_TIP_SCREENCOLOR             10885
#define IDS_TIP_INVERSECOLOR            10886
#define IDS_TIP_TRANSPARENTCOLOR        10887   // 5.0
#define IDS_TIP_PALETTE                 10888   // 4.0
#define IDS_TIP_LOADPALETTE             10889   // 4.0
#define IDS_TIP_SAVEPALETTE             10890   // 4.0
#define IDS_TIP_RGBCOLOR                10891   // 4.0 (renamed)
#define IDS_TIP_RGBACOLOR               10892   // 4.0
//
#define IDS_TIP_POINTER                 10893
#define IDS_TIP_PICTURE                 10894
#define IDS_TIP_TEXT                    10895
#define IDS_TIP_EDITBOX                 10896
#define IDS_TIP_GROUPBOX                10897
#define IDS_TIP_PUSHBUTTON              10898
#define IDS_TIP_CHECKBOX                10899
#define IDS_TIP_RADIOBUTTON             10900
#define IDS_TIP_COMBOBOX                10901
#define IDS_TIP_LISTBOX                 10902
#define IDS_TIP_HSCROLLBAR              10903
#define IDS_TIP_VSCROLLBAR              10904
#define IDS_TIP_UPDOWN                  10905
#define IDS_TIP_PROGRESS                10906
#define IDS_TIP_TRACKBAR                10907
#define IDS_TIP_HOTKEY                  10908
#define IDS_TIP_LISTVIEW                10909
#define IDS_TIP_TREEVIEW                10910
#define IDS_TIP_TABCONTROL              10911
#define IDS_TIP_ANIMATE                 10912
#define IDS_TIP_RICHEDIT                10913
#define IDS_TIP_RICHED20                10914   // 4.50
#define IDS_TIP_DATETIME                10915
#define IDS_TIP_MONTHCAL                10916
#define IDS_TIP_COMBOBOXEX              10917
#define IDS_TIP_REBAR                   10918
#define IDS_TIP_PAGER                   10919
#define IDS_TIP_TOOLBAR                 10920
#define IDS_TIP_STATUSBAR               10921
#define IDS_TIP_SYSLINK                 10922   // 5.0
#define IDS_TIP_IPADDRESS               10923   // 5.0
#define IDS_TIP_NETADDRESS              10924   // 5.0
#define IDS_TIP_SPLITBUTTON             10925   // 5.0
#define IDS_TIP_COMMANDLINK             10926   // 5.0
#define IDS_TIP_NATIVEFONT              10927   // 5.0
#define IDS_TIP_CUSTOM                  10928
//
#define IDS_TIP_TEST                    10929
#define IDS_TIP_LOCKCONTROLS            10930
#define IDS_TIP_ORDERCONTROLS           10931
#define IDS_TIP_ARRPUSHBOTTOM           10932
#define IDS_TIP_ARRPUSHRIGHT            10933
#define IDS_TIP_ALIGNLEFT               10934
#define IDS_TIP_ALIGNRIGHT              10935
#define IDS_TIP_ALIGNTOP                10936
#define IDS_TIP_ALIGNBOTTOM             10937
#define IDS_TIP_ALIGNHORZ               10938
#define IDS_TIP_ALIGNVERT               10939
#define IDS_TIP_SPACEHORZ               10940
#define IDS_TIP_SPACEVERT               10941
#define IDS_TIP_ARRSIZEWIDTH            10942
#define IDS_TIP_ARRSIZEHEIGHT           10943
#define IDS_TIP_ARRSIZEBOTH             10944
#define IDS_TIP_CENTERHORZ              10945
#define IDS_TIP_CENTERVERT              10946
//
#define IDS_TIP_NEWFOLDER               10947
#define IDS_TIP_NEWFILE                 10948
#define IDS_TIP_NEWTOOL                 10949
#define IDS_TIP_NEWHELP                 10950
#define IDS_TIP_NEWSNIPPET              10951   // 5.0
#define IDS_TIP_IMPORT                  10952   // 5.0
#define IDS_TIP_EXPORT                  10953   // 5.0
#define IDS_TIP_MOVEUP                  10954
#define IDS_TIP_MOVEDOWN                10955
#define IDS_TIP_DEFAULTS                10956   // 10.0
//
#define IDS_TIP_NEWIMAGE                10957
#define IDS_TIP_DELETEIMAGE             10958
//
#define IDS_TIP_NEWMACRO                10959   // 6.50
#define IDS_TIP_EDITMACRO               10960   // 6.50
//
#define IDS_TIP_SOURCEFILES             10961
#define IDS_TIP_TARGETFILES             10962
#define IDS_TIP_CLOSE                   10963
//
#define IDS_TIP_BACK                    10964   // 7.0
#define IDS_TIP_FORWARD                 10965   // 7.0
#define IDS_TIP_HOME                    10966   // 8.0
#define IDS_TIP_REFRESH                 10967   // 7.0
#define IDS_TIP_CERTIFICATE             10968   // 7.0
//
#define IDS_TIP_PREVCHANGE              10969   // 7.0
#define IDS_TIP_NEXTCHANGE              10970   // 7.0
#define IDS_TIP_STOP                    10971   // 7.0
#define IDS_TIP_EXPAND                  10972   // 8.0
#define IDS_TIP_OUTLINE                 10973   // 8.0
//
// Color descriptions.
//
#define IDS_COLOR_TEXT                  10974
#define IDS_COLOR_ATTRIBUTE             10975   // 11.0
#define IDS_COLOR_KEYWORD               10976
#define IDS_COLOR_COMMENT               10977
#define IDS_COLOR_NUMBER                10978
#define IDS_COLOR_STRING                10979
#define IDS_COLOR_PREPROC               10980
#define IDS_COLOR_FUNCTION              10981
#define IDS_COLOR_OPERATOR              10982
#define IDS_COLOR_SELTEXT               10983
#define IDS_COLOR_BREAKPOINT            10984
#define IDS_COLOR_DEBUGLINE             10985
#define IDS_COLOR_DEBUGASM              10986   // 10.0
#define IDS_COLOR_PROFLINE              10987   // 6.50
#define IDS_COLOR_DIFFBLOB              10988   // 7.0
#define IDS_COLOR_DIFFLEFT              10989   // 7.0
#define IDS_COLOR_DIFFRIGHT             10990   // 7.0
#define IDS_COLORTABLE                  10991
//
// Encoding descriptions.
//
#define IDS_ENCODING_ANSI               10992   // 5.0 (#1)
#define IDS_ENCODING_OEM                10993   // 5.0 (#2)
#define IDS_ENCODING_UTF8               10994   // 5.0 (#3)
#define IDS_ENCODING_UTF8_NO_BOM        10995   // 5.0 (#4)
#define IDS_ENCODING_UTF16_LE           10996   // 5.0 (#5)
#define IDS_ENCODING_UTF16_BE           10997   // 5.0 (#6)
#define IDS_ENCODING_UTF32_LE           10998   // 5.0 (#7)
#define IDS_ENCODING_UTF32_BE           10999   // 5.0 (#8)
//
// Startup descriptions.
//
#define IDS_STARTUP_WELCOME             11000   // 7.0
#define IDS_STARTUP_PROJECT             11001   // 7.0
#define IDS_STARTUP_HOMEPAGE            11002   // 7.0
#define IDS_STARTUP_EMPTY               11003   // 7.0
//
#define IDS_DESC_GENERAL                11004
#define IDS_DESC_MYSTYLES               11005
#define IDS_DESC_STYLES                 11006
#define IDS_DESC_EXSTYLES               11007
#define IDS_DESC_RESIZER                11008   // 6.0
#define IDS_DESC_NAME                   11009
#define IDS_DESC_TEXT                   11010
#define IDS_DESC_ORDER                  11011
#define IDS_DESC_HELP                   11012   // 5.0
#define IDS_DESC_LEFT                   11013
#define IDS_DESC_TOP                    11014
#define IDS_DESC_WIDTH                  11015
#define IDS_DESC_HEIGHT                 11016
#define IDS_DESC_VERTRESIZER            11017   // 6.0
#define IDS_DESC_HORZRESIZER            11018   // 6.0
#define IDS_DESC_FONTNAME               11019
#define IDS_DESC_FONTSIZE               11020
#define IDS_DESC_FONTWEIGHT             11021
#define IDS_DESC_FONTCHARSET            11022
#define IDS_DESC_FONTITALIC             11023
#define IDS_DESC_CLASSNAME              11024
#define IDS_DESC_MENUNAME               11025
#define IDS_DESC_STYLE                  11026
#define IDS_DESC_ALIGNMENT              11027
#define IDS_DESC_TYPE                   11028
#define IDS_DESC_OWNERDRAW              11029
#define IDS_DESC_SELECTION              11030
#define IDS_DESC_POINT                  11031
#define IDS_DESC_VIEW                   11032
#define IDS_DESC_SORT                   11033
#define IDS_DESC_FOCUS                  11034
#define IDS_DESC_FORMAT                 11035
#define IDS_DESC_IMAGE                  11036
#define IDS_DESC_ELLIPSIS               11037
#define IDS_DESC_VERTALIGNMENT          11038
#define IDS_DESC_WS_OVERLAPPED          11039
#define IDS_DESC_WS_POPUP               11040
#define IDS_DESC_WS_CHILD               11041
#define IDS_DESC_WS_CAPTION             11042
#define IDS_DESC_WS_SYSMENU             11043
#define IDS_DESC_WS_VISIBLE             11044
#define IDS_DESC_WS_DISABLED            11045
#define IDS_DESC_WS_BORDER              11046
#define IDS_DESC_WS_GROUP               11047
#define IDS_DESC_WS_TABSTOP             11048
#define IDS_DESC_WS_HSCROLL             11049
#define IDS_DESC_WS_VSCROLL             11050
#define IDS_DESC_WS_MINIMIZEBOX         11051
#define IDS_DESC_WS_MAXIMIZEBOX         11052
#define IDS_DESC_WS_CLIPSIBLINGS        11053
#define IDS_DESC_WS_CLIPCHILDREN        11054
#define IDS_DESC_WS_THICKFRAME          11055
#define IDS_DESC_DS_MODALFRAME          11056
#define IDS_DESC_DS_SYSMODAL            11057
#define IDS_DESC_DS_ABSALIGN            11058
#define IDS_DESC_DS_CONTEXTHELP         11059
#define IDS_DESC_DS_SETFOREGROUND       11060
#define IDS_DESC_DS_3DLOOK              11061
#define IDS_DESC_DS_NOFAILCREATE        11062
#define IDS_DESC_DS_NOIDLEMSG           11063
#define IDS_DESC_DS_CONTROL             11064
#define IDS_DESC_DS_CENTER              11065
#define IDS_DESC_DS_CENTERMOUSE         11066
#define IDS_DESC_DS_LOCALEDIT           11067
#define IDS_DESC_SS_BITMAP              11068
#define IDS_DESC_SS_ICON                11069
#define IDS_DESC_SS_ENHMETAFILE         11070
#define IDS_DESC_SS_BLACKRECT           11071
#define IDS_DESC_SS_GRAYRECT            11072
#define IDS_DESC_SS_WHITERECT           11073
#define IDS_DESC_SS_BLACKFRAME          11074
#define IDS_DESC_SS_GRAYFRAME           11075
#define IDS_DESC_SS_WHITEFRAME          11076
#define IDS_DESC_SS_ETCHEDHORZ          11077
#define IDS_DESC_SS_ETCHEDVERT          11078
#define IDS_DESC_SS_ETCHEDFRAME         11079
#define IDS_DESC_SS_CENTERIMAGE         11080
#define IDS_DESC_SS_REALSIZEIMAGE       11081
#define IDS_DESC_SS_REALSIZECONTROL     11082   // 4.0
#define IDS_DESC_SS_SUNKEN              11083
#define IDS_DESC_SS_LEFT                11084
#define IDS_DESC_SS_CENTER              11085
#define IDS_DESC_SS_RIGHT               11086
#define IDS_DESC_SS_SIMPLE              11087
#define IDS_DESC_SS_LEFTNOWORDWRAP      11088
#define IDS_DESC_SS_OWNERDRAW           11089
#define IDS_DESC_SS_NOPREFIX            11090
#define IDS_DESC_SS_NOTIFY              11091
#define IDS_DESC_SS_RIGHTJUST           11092
#define IDS_DESC_SS_NOELLIPSIS          11093
#define IDS_DESC_SS_ENDELLIPSIS         11094
#define IDS_DESC_SS_PATHELLIPSIS        11095
#define IDS_DESC_SS_WORDELLIPSIS        11096
#define IDS_DESC_ES_LEFT                11097
#define IDS_DESC_ES_CENTER              11098
#define IDS_DESC_ES_RIGHT               11099
#define IDS_DESC_ES_MULTILINE           11100
#define IDS_DESC_ES_NUMBER              11101
#define IDS_DESC_ES_AUTOHSCROLL         11102
#define IDS_DESC_ES_AUTOVSCROLL         11103
#define IDS_DESC_ES_PASSWORD            11104
#define IDS_DESC_ES_NOHIDESEL           11105
#define IDS_DESC_ES_OEMCONVERT          11106
#define IDS_DESC_ES_WANTRETURN          11107
#define IDS_DESC_ES_UPPERCASE           11108
#define IDS_DESC_ES_LOWERCASE           11109
#define IDS_DESC_ES_READONLY            11110
#define IDS_DESC_ES_DISABLENOSCROLL     11111
#define IDS_DESC_BS_TEXT                11112
#define IDS_DESC_BS_ICON                11113
#define IDS_DESC_BS_BITMAP              11114
#define IDS_DESC_BS_NOTIFY              11115
#define IDS_DESC_BS_FLAT                11116
#define IDS_DESC_BS_PUSHBUTTON          11117
#define IDS_DESC_BS_DEFPUSHBUTTON       11118
#define IDS_DESC_BS_PUSHBOX             11119   // 5.0
#define IDS_DESC_BS_OWNERDRAW           11120
#define IDS_DESC_BS_MULTILINE           11121
#define IDS_DESC_BS_CHECKBOX            11122
#define IDS_DESC_BS_AUTOCHECKBOX        11123
#define IDS_DESC_BS_3STATE              11124
#define IDS_DESC_BS_AUTO3STATE          11125
#define IDS_DESC_BS_LEFTTEXT            11126
#define IDS_DESC_BS_PUSHLIKE            11127
#define IDS_DESC_BS_RADIOBUTTON         11128
#define IDS_DESC_BS_AUTORADIOBUTTON     11129
#define IDS_DESC_BS_LEFT                11130
#define IDS_DESC_BS_CENTER              11131
#define IDS_DESC_BS_RIGHT               11132
#define IDS_DESC_BS_TOP                 11133
#define IDS_DESC_BS_VCENTER             11134
#define IDS_DESC_BS_BOTTOM              11135
#define IDS_DESC_BS_NOALIGN             11136
#define IDS_DESC_BS_SPLITBUTTON         11137   // 5.0
#define IDS_DESC_BS_DEFSPLITBUTTON      11138   // 5.0
#define IDS_DESC_BS_COMMANDLINK         11139   // 5.0
#define IDS_DESC_BS_DEFCOMMANDLINK      11140   // 5.0
#define IDS_DESC_CBS_SIMPLE             11141
#define IDS_DESC_CBS_DROPDOWN           11142
#define IDS_DESC_CBS_DROPDOWNLIST       11143
#define IDS_DESC_OD_NO                  11144
#define IDS_DESC_OD_FIXED               11145
#define IDS_DESC_OD_VARIABLE            11146
#define IDS_DESC_CBS_AUTOHSCROLL        11147
#define IDS_DESC_CBS_OEMCONVERT         11148
#define IDS_DESC_CBS_SORT               11149
#define IDS_DESC_CBS_HASSTRINGS         11150
#define IDS_DESC_CBS_NOINTEGRALHEIGHT   11151
#define IDS_DESC_CBS_DISABLENOSCROLL    11152
#define IDS_DESC_CBS_UPPERCASE          11153
#define IDS_DESC_CBS_LOWERCASE          11154
#define IDS_DESC_LBS_SINGLESEL          11155
#define IDS_DESC_LBS_MULTIPLESEL        11156
#define IDS_DESC_LBS_EXTENDEDSEL        11157
#define IDS_DESC_LBS_NOSEL              11158
#define IDS_DESC_LBS_SORT               11159
#define IDS_DESC_LBS_HASSTRINGS         11160
#define IDS_DESC_LBS_NOINTEGRALHEIGHT   11161
#define IDS_DESC_LBS_DISABLENOSCROLL    11162
#define IDS_DESC_LBS_NOTIFY             11163
#define IDS_DESC_LBS_MULTICOLUMN        11164
#define IDS_DESC_LBS_NOREDRAW           11165
#define IDS_DESC_LBS_USETABSTOPS        11166
#define IDS_DESC_LBS_WANTKEYBOARDINPUT  11167
#define IDS_DESC_LBS_NODATA             11168
#define IDS_DESC_UDS_UNATTACHED         11169
#define IDS_DESC_UDS_ALIGNLEFT          11170
#define IDS_DESC_UDS_ALIGNRIGHT         11171
#define IDS_DESC_UDS_HORZ               11172
#define IDS_DESC_UDS_AUTOBUDDY          11173
#define IDS_DESC_UDS_SETBUDDYINT        11174
#define IDS_DESC_UDS_NOTHOUSANDS        11175
#define IDS_DESC_UDS_WRAP               11176
#define IDS_DESC_UDS_ARROWKEYS          11177
#define IDS_DESC_UDS_HOTTRACK           11178
#define IDS_DESC_PBS_VERTICAL           11179
#define IDS_DESC_PBS_SMOOTH             11180
#define IDS_DESC_PBS_MARQUEE            11181   // 4.0
#define IDS_DESC_TBS_BOTH               11182
#define IDS_DESC_TBS_LEFT               11183
#define IDS_DESC_TBS_RIGHT              11184
#define IDS_DESC_TBS_VERT               11185
#define IDS_DESC_TBS_NOTICKS            11186
#define IDS_DESC_TBS_AUTOTICKS          11187
#define IDS_DESC_TBS_ENABLESELRANGE     11188
#define IDS_DESC_TBS_FIXEDLENGTH        11189
#define IDS_DESC_TBS_NOTHUMB            11190
#define IDS_DESC_TBS_TOOLTIPS           11191
#define IDS_DESC_LVS_ICON               11192
#define IDS_DESC_LVS_SMALLICON          11193
#define IDS_DESC_LVS_LIST               11194
#define IDS_DESC_LVS_REPORT             11195
#define IDS_DESC_LVS_ALIGNTOP           11196
#define IDS_DESC_LVS_ALIGNLEFT          11197
#define IDS_DESC_LVS_NOSORT             11198
#define IDS_DESC_LVS_SORTASCENDING      11199
#define IDS_DESC_LVS_SORTDESCENDING     11200
#define IDS_DESC_LVS_SINGLESEL          11201
#define IDS_DESC_LVS_SHOWSELALWAYS      11202
#define IDS_DESC_LVS_AUTOARRANGE        11203
#define IDS_DESC_LVS_NOLABELWRAP        11204
#define IDS_DESC_LVS_EDITLABELS         11205
#define IDS_DESC_LVS_NOSCROLL           11206
#define IDS_DESC_LVS_NOCOLUMNHEADER     11207
#define IDS_DESC_LVS_NOSORTHEADER       11208
#define IDS_DESC_LVS_SHAREIMAGELISTS    11209
#define IDS_DESC_LVS_OWNERDRAWFIXED     11210
#define IDS_DESC_LVS_OWNERDATA          11211
#define IDS_DESC_TVS_HASBUTTONS         11212
#define IDS_DESC_TVS_HASLINES           11213
#define IDS_DESC_TVS_LINESATROOT        11214
#define IDS_DESC_TVS_EDITLABELS         11215
#define IDS_DESC_TVS_DISABLEDRAGDROP    11216
#define IDS_DESC_TVS_SHOWSELALWAYS      11217
#define IDS_DESC_TVS_NOTOOLTIPS         11218
#define IDS_DESC_TVS_CHECKBOXES         11219
#define IDS_DESC_TVS_TRACKSELECT        11220
#define IDS_DESC_TVS_SINGLEEXPAND       11221
#define IDS_DESC_TVS_INFOTIP            11222
#define IDS_DESC_TVS_FULLROWSELECT      11223
#define IDS_DESC_TVS_NOSCROLL           11224
#define IDS_DESC_TVS_NONEVENHEIGHT      11225
#define IDS_DESC_TCS_RIGHTJUSTIFY       11226
#define IDS_DESC_TCS_FIXEDWIDTH         11227
#define IDS_DESC_TCS_RAGGEDRIGHT        11228
#define IDS_DESC_TCS_FOCUSDEFAULT       11229
#define IDS_DESC_TCS_FOCUSONBUTTONDOWN  11230
#define IDS_DESC_TCS_FOCUSNEVER         11231
#define IDS_DESC_TCS_BUTTONS            11232
#define IDS_DESC_TCS_FLATBUTTONS        11233
#define IDS_DESC_TCS_TOOLTIPS           11234
#define IDS_DESC_TCS_MULTILINE          11235
#define IDS_DESC_TCS_OWNERDRAWFIXED     11236
#define IDS_DESC_TCS_FORCELABELLEFT     11237
#define IDS_DESC_TCS_FORCEICONLEFT      11238
#define IDS_DESC_TCS_HOTTRACK           11239
#define IDS_DESC_TCS_BOTTOM             11240
#define IDS_DESC_TCS_MULTISELECT        11241
#define IDS_DESC_TCS_SCROLLOPPOSITE     11242
#define IDS_DESC_TCS_VERTICAL           11243
#define IDS_DESC_ACS_CENTER             11244
#define IDS_DESC_ACS_TRANSPARENT        11245
#define IDS_DESC_ACS_AUTOPLAY           11246
#define IDS_DESC_ACS_TIMER              11247
#define IDS_DESC_DTS_SHORTDATEFORMAT    11248
#define IDS_DESC_DTS_LONGDATEFORMAT     11249
#define IDS_DESC_DTS_TIMEFORMAT         11250
#define IDS_DESC_DTS_RIGHTALIGN         11251
#define IDS_DESC_DTS_UPDOWN             11252
#define IDS_DESC_DTS_SHOWNONE           11253
#define IDS_DESC_MCS_DAYSTATE           11254
#define IDS_DESC_MCS_MULTISELECT        11255
#define IDS_DESC_MCS_WEEKNUMBERS        11256
#define IDS_DESC_MCS_NOTODAYCIRCLE      11257
#define IDS_DESC_MCS_NOTODAY            11258
#define IDS_DESC_CCS_NORESIZE           11259
#define IDS_DESC_CCS_TOP                11260
#define IDS_DESC_CCS_BOTTOM             11261
#define IDS_DESC_CCS_LEFT               11262
#define IDS_DESC_CCS_RIGHT              11263
#define IDS_DESC_CCS_NODIVIDER          11264
#define IDS_DESC_CCS_ADJUSTABLE         11265
#define IDS_DESC_RBS_VARHEIGHT          11266
#define IDS_DESC_RBS_BANDBORDERS        11267
#define IDS_DESC_RBS_FIXEDORDER         11268
#define IDS_DESC_RBS_REGISTERDROP       11269
#define IDS_DESC_RBS_AUTOSIZE           11270
#define IDS_DESC_RBS_VERTICALGRIPPER    11271
#define IDS_DESC_RBS_DBLCLKTOGGLE       11272
#define IDS_DESC_PGS_HORZ               11273
#define IDS_DESC_PGS_AUTOSCROLL         11274
#define IDS_DESC_PGS_DRAGNDROP          11275
#define IDS_DESC_TBSTYLE_FLAT           11276
#define IDS_DESC_TBSTYLE_LIST           11277
#define IDS_DESC_TBSTYLE_WRAPABLE       11278
#define IDS_DESC_TBSTYLE_TRANSPARENT    11279
#define IDS_DESC_TBSTYLE_TOOLTIPS       11280
#define IDS_DESC_TBSTYLE_ALTDRAG        11281
#define IDS_DESC_TBSTYLE_CUSTOMERASE    11282
#define IDS_DESC_TBSTYLE_REGISTERDROP   11283
#define IDS_DESC_SBARS_SIZEGRIP         11284
#define IDS_DESC_LWS_TRANSPARENT        11285   // 5.0
#define IDS_DESC_LWS_IGNORERETURN       11286   // 5.0
#define IDS_DESC_LWS_NOPREFIX           11287   // 5.0
#define IDS_DESC_LWS_USEVISUALSTYLE     11288   // 5.0
#define IDS_DESC_LWS_USECUSTOMTEXT      11289   // 5.0
#define IDS_DESC_LWS_RIGHT              11290   // 5.0
#define IDS_DESC_NFS_EDIT               11291   // 5.0
#define IDS_DESC_NFS_STATIC             11292   // 5.0
#define IDS_DESC_NFS_LISTCOMBO          11293   // 5.0
#define IDS_DESC_NFS_BUTTON             11294   // 5.0
#define IDS_DESC_NFS_ALL                11295   // 5.0
#define IDS_DESC_NFS_USEFONTASSOC       11296   // 5.0
#define IDS_DESC_WS_EX_CLIENTEDGE       11297
#define IDS_DESC_WS_EX_STATICEDGE       11298
#define IDS_DESC_WS_EX_TRANSPARENT      11299
#define IDS_DESC_WS_EX_ACCEPTFILES      11300
#define IDS_DESC_WS_EX_RIGHT            11301
#define IDS_DESC_WS_EX_LEFTSCROLLBAR    11302
#define IDS_DESC_WS_EX_TOOLWINDOW       11303
#define IDS_DESC_WS_EX_CONTROLPARENT    11304
#define IDS_DESC_WS_EX_CONTEXTHELP      11305
#define IDS_DESC_WS_EX_NOPARENTNOTIFY   11306
#define IDS_DESC_WS_EX_APPWINDOW        11307   // 4.0
#define IDS_DESC_WS_EX_TOPMOST          11308   // 4.0
#define IDS_DESC_WS_EX_NOACTIVATE       11309   // 4.0
#define IDS_HELP_NAME                   11310
#define IDS_HELP_TEXT                   11311
#define IDS_HELP_ORDER                  11312
#define IDS_HELP_HELP                   11313   // 5.0
#define IDS_HELP_LEFT                   11314
#define IDS_HELP_TOP                    11315
#define IDS_HELP_WIDTH                  11316
#define IDS_HELP_HEIGHT                 11317
#define IDS_HELP_VERTRESIZER            11318   // 6.0
#define IDS_HELP_HORZRESIZER            11319   // 6.0
#define IDS_HELP_FONTNAME               11320
#define IDS_HELP_FONTSIZE               11321
#define IDS_HELP_FONTWEIGHT             11322
#define IDS_HELP_FONTCHARSET            11323
#define IDS_HELP_FONTITALIC             11324
#define IDS_HELP_CLASSNAME              11325
#define IDS_HELP_MENUNAME               11326
#define IDS_HELP_STYLES                 11327   // 4.0
#define IDS_HELP_EXSTYLES               11328   // 4.0
#define IDS_HELP_STYLE                  11329
#define IDS_HELP_ALIGNMENT              11330
#define IDS_HELP_TYPE                   11331
#define IDS_HELP_OWNERDRAW              11332
#define IDS_HELP_SELECTION              11333
#define IDS_HELP_POINT                  11334
#define IDS_HELP_VIEW                   11335
#define IDS_HELP_SORT                   11336
#define IDS_HELP_FOCUS                  11337
#define IDS_HELP_FORMAT                 11338
#define IDS_HELP_IMAGE                  11339
#define IDS_HELP_ELLIPSIS               11340
#define IDS_HELP_VERTALIGNMENT          11341
#define IDS_HELP_WS_CAPTION             11342
#define IDS_HELP_WS_SYSMENU             11343
#define IDS_HELP_WS_VISIBLE             11344
#define IDS_HELP_WS_DISABLED            11345
#define IDS_HELP_WS_BORDER              11346
#define IDS_HELP_WS_GROUP               11347
#define IDS_HELP_WS_TABSTOP             11348
#define IDS_HELP_WS_HSCROLL             11349
#define IDS_HELP_WS_VSCROLL             11350
#define IDS_HELP_WS_MINIMIZEBOX         11351
#define IDS_HELP_WS_MAXIMIZEBOX         11352
#define IDS_HELP_WS_CLIPSIBLINGS        11353
#define IDS_HELP_WS_CLIPCHILDREN        11354
#define IDS_HELP_WS_THICKFRAME          11355
#define IDS_HELP_DS_MODALFRAME          11356
#define IDS_HELP_DS_SYSMODAL            11357
#define IDS_HELP_DS_ABSALIGN            11358
#define IDS_HELP_DS_CONTEXTHELP         11359
#define IDS_HELP_DS_SETFOREGROUND       11360
#define IDS_HELP_DS_3DLOOK              11361
#define IDS_HELP_DS_NOFAILCREATE        11362
#define IDS_HELP_DS_NOIDLEMSG           11363
#define IDS_HELP_DS_CONTROL             11364
#define IDS_HELP_DS_CENTER              11365
#define IDS_HELP_DS_CENTERMOUSE         11366
#define IDS_HELP_DS_LOCALEDIT           11367
#define IDS_HELP_SS_CENTERIMAGE         11368
#define IDS_HELP_SS_REALSIZEIMAGE       11369
#define IDS_HELP_SS_REALSIZECONTROL     11370   // 4.0
#define IDS_HELP_SS_SUNKEN              11371
#define IDS_HELP_SS_SIMPLE              11372
#define IDS_HELP_SS_LEFTNOWORDWRAP      11373
#define IDS_HELP_SS_OWNERDRAW           11374
#define IDS_HELP_SS_NOPREFIX            11375
#define IDS_HELP_SS_NOTIFY              11376
#define IDS_HELP_SS_RIGHTJUST           11377
#define IDS_HELP_ES_MULTILINE           11378
#define IDS_HELP_ES_NUMBER              11379
#define IDS_HELP_ES_AUTOHSCROLL         11380
#define IDS_HELP_ES_AUTOVSCROLL         11381
#define IDS_HELP_ES_PASSWORD            11382
#define IDS_HELP_ES_NOHIDESEL           11383
#define IDS_HELP_ES_OEMCONVERT          11384
#define IDS_HELP_ES_WANTRETURN          11385
#define IDS_HELP_ES_UPPERCASE           11386
#define IDS_HELP_ES_LOWERCASE           11387
#define IDS_HELP_ES_READONLY            11388
#define IDS_HELP_ES_DISABLENOSCROLL     11389
#define IDS_HELP_BS_NOTIFY              11390
#define IDS_HELP_BS_FLAT                11391
#define IDS_HELP_BS_MULTILINE           11392
#define IDS_HELP_BS_LEFTTEXT            11393
#define IDS_HELP_BS_PUSHLIKE            11394
#define IDS_HELP_CBS_AUTOHSCROLL        11395
#define IDS_HELP_CBS_OEMCONVERT         11396
#define IDS_HELP_CBS_SORT               11397
#define IDS_HELP_CBS_HASSTRINGS         11398
#define IDS_HELP_CBS_NOINTEGRALHEIGHT   11399
#define IDS_HELP_CBS_DISABLENOSCROLL    11400
#define IDS_HELP_CBS_UPPERCASE          11401
#define IDS_HELP_CBS_LOWERCASE          11402
#define IDS_HELP_LBS_SORT               11403
#define IDS_HELP_LBS_HASSTRINGS         11404
#define IDS_HELP_LBS_NOINTEGRALHEIGHT   11405
#define IDS_HELP_LBS_DISABLENOSCROLL    11406
#define IDS_HELP_LBS_NOTIFY             11407
#define IDS_HELP_LBS_MULTICOLUMN        11408
#define IDS_HELP_LBS_NOREDRAW           11409
#define IDS_HELP_LBS_USETABSTOPS        11410
#define IDS_HELP_LBS_WANTKEYBOARDINPUT  11411
#define IDS_HELP_LBS_NODATA             11412
#define IDS_HELP_UDS_HORZ               11413
#define IDS_HELP_UDS_AUTOBUDDY          11414
#define IDS_HELP_UDS_SETBUDDYINT        11415
#define IDS_HELP_UDS_NOTHOUSANDS        11416
#define IDS_HELP_UDS_WRAP               11417
#define IDS_HELP_UDS_ARROWKEYS          11418
#define IDS_HELP_UDS_HOTTRACK           11419
#define IDS_HELP_PBS_VERTICAL           11420
#define IDS_HELP_PBS_SMOOTH             11421
#define IDS_HELP_PBS_MARQUEE            11422   // 4.0
#define IDS_HELP_TBS_VERT               11423
#define IDS_HELP_TBS_NOTICKS            11424
#define IDS_HELP_TBS_AUTOTICKS          11425
#define IDS_HELP_TBS_ENABLESELRANGE     11426
#define IDS_HELP_TBS_FIXEDLENGTH        11427
#define IDS_HELP_TBS_NOTHUMB            11428
#define IDS_HELP_TBS_TOOLTIPS           11429
#define IDS_HELP_LVS_SINGLESEL          11430
#define IDS_HELP_LVS_SHOWSELALWAYS      11431
#define IDS_HELP_LVS_AUTOARRANGE        11432
#define IDS_HELP_LVS_NOLABELWRAP        11433
#define IDS_HELP_LVS_EDITLABELS         11434
#define IDS_HELP_LVS_NOSCROLL           11435
#define IDS_HELP_LVS_NOCOLUMNHEADER     11436
#define IDS_HELP_LVS_NOSORTHEADER       11437
#define IDS_HELP_LVS_SHAREIMAGELISTS    11438
#define IDS_HELP_LVS_OWNERDRAWFIXED     11439
#define IDS_HELP_LVS_OWNERDATA          11440
#define IDS_HELP_TVS_HASBUTTONS         11441
#define IDS_HELP_TVS_HASLINES           11442
#define IDS_HELP_TVS_LINESATROOT        11443
#define IDS_HELP_TVS_EDITLABELS         11444
#define IDS_HELP_TVS_DISABLEDRAGDROP    11445
#define IDS_HELP_TVS_SHOWSELALWAYS      11446
#define IDS_HELP_TVS_NOTOOLTIPS         11447
#define IDS_HELP_TVS_CHECKBOXES         11448
#define IDS_HELP_TVS_TRACKSELECT        11449
#define IDS_HELP_TVS_SINGLEEXPAND       11450
#define IDS_HELP_TVS_INFOTIP            11451
#define IDS_HELP_TVS_FULLROWSELECT      11452
#define IDS_HELP_TVS_NOSCROLL           11453
#define IDS_HELP_TVS_NONEVENHEIGHT      11454
#define IDS_HELP_TCS_BUTTONS            11455
#define IDS_HELP_TCS_FLATBUTTONS        11456
#define IDS_HELP_TCS_TOOLTIPS           11457
#define IDS_HELP_TCS_MULTILINE          11458
#define IDS_HELP_TCS_OWNERDRAWFIXED     11459
#define IDS_HELP_TCS_FORCELABELLEFT     11460
#define IDS_HELP_TCS_FORCEICONLEFT      11461
#define IDS_HELP_TCS_HOTTRACK           11462
#define IDS_HELP_TCS_BOTTOM             11463
#define IDS_HELP_TCS_MULTISELECT        11464
#define IDS_HELP_TCS_SCROLLOPPOSITE     11465
#define IDS_HELP_TCS_VERTICAL           11466
#define IDS_HELP_ACS_CENTER             11467
#define IDS_HELP_ACS_TRANSPARENT        11468
#define IDS_HELP_ACS_AUTOPLAY           11469
#define IDS_HELP_ACS_TIMER              11470
#define IDS_HELP_DTS_RIGHTALIGN         11471
#define IDS_HELP_DTS_UPDOWN             11472
#define IDS_HELP_DTS_SHOWNONE           11473
#define IDS_HELP_MCS_DAYSTATE           11474
#define IDS_HELP_MCS_MULTISELECT        11475
#define IDS_HELP_MCS_WEEKNUMBERS        11476
#define IDS_HELP_MCS_NOTODAYCIRCLE      11477
#define IDS_HELP_MCS_NOTODAY            11478
#define IDS_HELP_CCS_NORESIZE           11479
#define IDS_HELP_CCS_TOP                11480
#define IDS_HELP_CCS_BOTTOM             11481
#define IDS_HELP_CCS_LEFT               11482
#define IDS_HELP_CCS_RIGHT              11483
#define IDS_HELP_CCS_NODIVIDER          11484
#define IDS_HELP_CCS_ADJUSTABLE         11485
#define IDS_HELP_RBS_VARHEIGHT          11486
#define IDS_HELP_RBS_BANDBORDERS        11487
#define IDS_HELP_RBS_FIXEDORDER         11488
#define IDS_HELP_RBS_REGISTERDROP       11489
#define IDS_HELP_RBS_AUTOSIZE           11490
#define IDS_HELP_RBS_VERTICALGRIPPER    11491
#define IDS_HELP_RBS_DBLCLKTOGGLE       11492
#define IDS_HELP_PGS_HORZ               11493
#define IDS_HELP_PGS_AUTOSCROLL         11494
#define IDS_HELP_PGS_DRAGNDROP          11495
#define IDS_HELP_TBSTYLE_FLAT           11496
#define IDS_HELP_TBSTYLE_LIST           11497
#define IDS_HELP_TBSTYLE_WRAPABLE       11498
#define IDS_HELP_TBSTYLE_TRANSPARENT    11499
#define IDS_HELP_TBSTYLE_TOOLTIPS       11500
#define IDS_HELP_TBSTYLE_ALTDRAG        11501
#define IDS_HELP_TBSTYLE_CUSTOMERASE    11502
#define IDS_HELP_TBSTYLE_REGISTERDROP   11503
#define IDS_HELP_SBARS_SIZEGRIP         11504
#define IDS_HELP_LWS_TRANSPARENT        11505   // 5.0
#define IDS_HELP_LWS_IGNORERETURN       11506   // 5.0
#define IDS_HELP_LWS_NOPREFIX           11507   // 5.0
#define IDS_HELP_LWS_USEVISUALSTYLE     11508   // 5.0
#define IDS_HELP_LWS_USECUSTOMTEXT      11509   // 5.0
#define IDS_HELP_LWS_RIGHT              11510   // 5.0
#define IDS_HELP_NFS_EDIT               11511   // 5.0
#define IDS_HELP_NFS_STATIC             11512   // 5.0
#define IDS_HELP_NFS_LISTCOMBO          11513   // 5.0
#define IDS_HELP_NFS_BUTTON             11514   // 5.0
#define IDS_HELP_NFS_ALL                11515   // 5.0
#define IDS_HELP_NFS_USEFONTASSOC       11516   // 5.0
#define IDS_HELP_WS_EX_CLIENTEDGE       11517
#define IDS_HELP_WS_EX_STATICEDGE       11518
#define IDS_HELP_WS_EX_TRANSPARENT      11519
#define IDS_HELP_WS_EX_ACCEPTFILES      11520
#define IDS_HELP_WS_EX_RIGHT            11521
#define IDS_HELP_WS_EX_LEFTSCROLLBAR    11522
#define IDS_HELP_WS_EX_TOOLWINDOW       11523
#define IDS_HELP_WS_EX_CONTROLPARENT    11524
#define IDS_HELP_WS_EX_CONTEXTHELP      11525
#define IDS_HELP_WS_EX_NOPARENTNOTIFY   11526
#define IDS_HELP_WS_EX_APPWINDOW        11527   // 4.0
#define IDS_HELP_WS_EX_TOPMOST          11528   // 4.0
#define IDS_HELP_WS_EX_NOACTIVATE       11529   // 4.0
//
#define IDS_ERR_CANTREADFILE            11530
#define IDS_ERR_CANTWRITEFILE           11531
#define IDS_ERR_LINETOOLONG             11532
#define IDS_ERR_INVALIDCHAR             11533
#define IDS_ERR_BADFILEFORMAT           11534
#define IDS_ERR_BADIMAGEFORMAT          11535
#define IDS_ERR_BADRSRCFORMAT           11536
#define IDS_ERR_BADSYNTAX               11537
#define IDS_ERR_OS2BITMAP               11538
#define IDS_ERR_UNKNOWNCODEC            11539
#define IDS_ERR_CODECERROR              11540
#define IDS_ERR_INVALIDVIDEO            11541
#define IDS_ERR_WFPPROTECTED            11542
#define IDS_ERR_TOOMANYCOLORS           11543
#define IDS_ERR_WRONGCHECKSUM           11544
#define IDS_ERR_BADEXECFORMAT           11545   // 5.0
#define IDS_ERR_NOFILEBUFSPACE          11546   // 13.0
#define IDS_ERR_TOOMANYIMAGES           11547   // 12.0
#define IDS_ERR_INTERNAL                11548   // 13.0
//
#define IDS_DIFF_ONLY_IN                11549   // 7.0
#define IDS_DIFF_DIFFERENT              11550   // 7.0
#define IDS_DIFF_IDENTICAL              11551   // 7.0
#define IDS_DIFF_SAME_SIZE              11552   // 7.0
#define IDS_DIFF_IDENTICAL_TIMES        11553   // 7.0
#define IDS_DIFF_IN_BLANKS_ONLY         11554   // 7.0
#define IDS_DIFF_BOTH_UNREADABLE        11555   // 7.0
#define IDS_DIFF_LEFT_UNREADABLE        11556   // 7.0
#define IDS_DIFF_RIGHT_UNREADABLE       11557   // 7.0
#define IDS_DIFF_UNREADABLE             11558   // 7.0
#define IDS_DIFF_IS_MORE_RECENT         11559   // 7.0
//
#define IDS_SCOPE_DOCUMENT              11560   // 9.0
#define IDS_SCOPE_PROJECT               11561   // 9.0
#define IDS_SCOPE_WORKSPACE             11562   // 9.0
//
#define CSTRINGS                        1562    // Number of strings

//
// Menu ID's ----------------------------------------------------------------
//

//
// File menu.
//
#define IDM_FILE_NEWPROJECT         6001
#define IDM_FILE_NEWSOURCE          6002
#define IDM_FILE_NEWRESOURCE        6003
#define IDM_FILE_NEWBITMAP          6004
#define IDM_FILE_NEWICON            6005
#define IDM_FILE_NEWCURSOR          6006
#define IDM_FILE_NEWANICURSOR       6007
#define IDM_FILE_NEWVIDEO           6008
#define IDM_FILE_NEWHEXDUMP         6009
#define IDM_FILE_NEWMSGTABLE        6010    // 3.0
#define IDM_FILE_NEWWEB             6011    // 7.0
#define IDM_FILE_NEWDIFF            6012    // 7.0
#define IDM_FILE_NEWADDIN           6013    // 8.0
#define IDM_FILE_OPEN               6014
#define IDM_FILE_OPENPROJ           6015    // 7.0 (Welcome page only)
#define IDM_FILE_CLOSE              6016
#define IDM_FILE_CLOSEPROJ          6017    // 5.0
#define IDM_FILE_SAVE               6018
#define IDM_FILE_SAVEAS             6019
#define IDM_FILE_SAVEALL            6020
#define IDM_FILE_PRINT              6021
#define IDM_FILE_PRINTSETUP         6022
#define IDM_FILE_PROPERTIES         6023
#define IDM_FILE_EXIT               6024
#define IDM_FILE_ADDIN              6025    // (placeholder, never used)
#define IDM_FILE_MRUFILE            6026    // room for 8 files.
#define IDM_FILE_MRUFILE_1          6027    // (placeholder, never used)
#define IDM_FILE_MRUFILE_2          6028    // (placeholder, never used)
#define IDM_FILE_MRUFILE_3          6029    // (placeholder, never used)
#define IDM_FILE_MRUFILE_4          6030    // (placeholder, never used)
#define IDM_FILE_MRUFILE_5          6031    // (placeholder, never used)
#define IDM_FILE_MRUFILE_6          6032    // (placeholder, never used)
#define IDM_FILE_MRUFILE_7          6033    // (placeholder, never used)
#define IDM_FILE_MRUFILE_8          6034    // (placeholder, never used)
#define IDM_FILE_MRUPROJ            6035    // room for 8 projects.
#define IDM_FILE_MRUPROJ_1          6036    // (placeholder, never used)
#define IDM_FILE_MRUPROJ_2          6037    // (placeholder, never used)
#define IDM_FILE_MRUPROJ_3          6038    // (placeholder, never used)
#define IDM_FILE_MRUPROJ_4          6039    // (placeholder, never used)
#define IDM_FILE_MRUPROJ_5          6040    // (placeholder, never used)
#define IDM_FILE_MRUPROJ_6          6041    // (placeholder, never used)
#define IDM_FILE_MRUPROJ_7          6042    // (placeholder, never used)
#define IDM_FILE_MRUPROJ_8          6043    // (placeholder, never used)
#define IDM_FILE_MRULINK            6044    // room for 8 links (7.0).
#define IDM_FILE_MRULINK_1          6045    // (placeholder, never used)
#define IDM_FILE_MRULINK_2          6046    // (placeholder, never used)
#define IDM_FILE_MRULINK_3          6047    // (placeholder, never used)
#define IDM_FILE_MRULINK_4          6048    // (placeholder, never used)
#define IDM_FILE_MRULINK_5          6049    // (placeholder, never used)
#define IDM_FILE_MRULINK_6          6050    // (placeholder, never used)
#define IDM_FILE_MRULINK_7          6051    // (placeholder, never used)
#define IDM_FILE_MRULINK_8          6052    // (placeholder, never used)
//
// Edit menu.
//
#define IDM_EDIT_UNDO               6053
#define IDM_EDIT_REDO               6054
#define IDM_EDIT_CUT                6055
#define IDM_EDIT_COPY               6056
#define IDM_EDIT_PASTE              6057
#define IDM_EDIT_INSERT             6058
#define IDM_EDIT_DELETE             6059
#define IDM_EDIT_DELETEWORD         6060
#define IDM_EDIT_SELECTALL          6061
#define IDM_EDIT_FIND               6062
#define IDM_EDIT_FINDNEXT           6063
#define IDM_EDIT_REPLACE            6064
#define IDM_EDIT_FILEFIND           6065
#define IDM_EDIT_GOTO               6066
#define IDM_EDIT_ADDIN              6067    // (placeholder, never used)
//
// View menu.
//
#define IDM_VIEW_SOURCEFILES        6068    // 5.0
#define IDM_VIEW_TARGETFILES        6069    // 5.0
#define IDM_VIEW_PROJECT            6070    // 5.0
#define IDM_VIEW_FILEFIND           6071    // 5.0
#define IDM_VIEW_OUTPUT             6072    // 5.0
#define IDM_VIEW_TRACE              6073    // 5.0
#define IDM_VIEW_BREAKPOINTS        6074    // 5.0
#define IDM_VIEW_AUTO               6075    // 5.0
#define IDM_VIEW_WATCH              6076    // 5.0
#define IDM_VIEW_LOCALS             6077    // 5.0
#define IDM_VIEW_GLOBALS            6078    // 5.0
#define IDM_VIEW_REGISTERS          6079    // 5.0
#define IDM_VIEW_STACK              6080    // 5.0
#define IDM_VIEW_MEMORY             6081    // 5.0
#define IDM_VIEW_THREADS            6082    // 5.0
#define IDM_VIEW_MODULES            6083    // 5.0
#define IDM_VIEW_EXCEPTIONS         6084    // 5.0
#define IDM_VIEW_HELPCONTENTS       6085    // 7.0
#define IDM_VIEW_HELPINDEX          6086    // 7.0
#define IDM_VIEW_HELPSEARCH         6087    // 8.0
#define IDM_VIEW_OUTLINE            6088    // 7.0
#define IDM_VIEW_EXPAND             6089    // 7.0
#define IDM_VIEW_SHOWTOOLBAR        6090
#define IDM_VIEW_SHOWSTATUSBAR      6091
#define IDM_VIEW_SHOWDOCTABS        6092
#define IDM_VIEW_SHOWWELCOME        6093    // 7.0
#define IDM_VIEW_TOGGLEFULLSCREEN   6094    // 8.0
#define IDM_VIEW_TOGGLEPROJPANE     6095    // 4.0 (hidden)
#define IDM_VIEW_TABPAGES           6096    // 5.0 (placeholder, never used)
#define IDM_VIEW_ADDIN              6097    // (placeholder, never used)
//
// Project menu.
//
#define IDM_PROJ_BUILD              6098    // Project menu.
#define IDM_PROJ_REBUILD            6099    // Project menu (5.0: IDM_PROJ_BUILDALL -> IDM_PROJ_REBUILD).
#define IDM_PROJ_CLEAN              6100    // Project menu (9.0).
#define IDM_PROJ_BUILDWKS           6101    // Project menu (5.0).
#define IDM_PROJ_REBUILDWKS         6102    // Project menu (5.0).
#define IDM_PROJ_CLEANWKS           6103    // Project menu (9.0).
#define IDM_PROJ_COMPILE            6104    // Project menu.
#define IDM_PROJ_STOPBUILD          6105    // Project menu.
#define IDM_PROJ_EXECUTE            6106    // Project menu.
#define IDM_PROJ_PROFILE            6107    // Project menu (6.50).
#define IDM_PROJ_ADDFILE            6108    // Project menu.
#define IDM_PROJ_ADDPROJECT         6109    // Project menu (4.0).
#define IDM_PROJ_MAKEALLPREQS       6110    // Project menu.
#define IDM_PROJ_ZIP                6111    // Project menu.
#define IDM_PROJ_UNZIP              6112    // Project menu.
#define IDM_PROJ_SETACTIVE          6113    // Project menu (4.0).
#define IDM_PROJ_DEPENDENCIES       6114    // Project menu (4.0).
#define IDM_PROJ_SETTINGS           6115    // Project menu.
#define IDM_PROJ_MODES              6116    // Project menu (9.0).
#define IDM_PROJ_WORKSPACE          6117    // Project menu (4.0).
#define IDM_PROJ_CTX_OPEN           6118    // Context menu (4.0).
#define IDM_PROJ_CTX_OPENAS_TEXT    6119    // Context menu (5.0).
#define IDM_PROJ_CTX_OPENAS_BINARY  6120    // Context menu (5.0).
#define IDM_PROJ_CTX_OPENFUNC       6121    // Context menu (8.0).
#define IDM_PROJ_CTX_ADDFILE        6122    // Context menu (4.0).
#define IDM_PROJ_CTX_DELETE         6123    // Context menu (4.0).
#define IDM_PROJ_CTX_RENAME         6124    // Context menu (4.0).
#define IDM_PROJ_CTX_EXCLUDE        6125    // Context menu (4.0).
#define IDM_PROJ_CTX_ZIP            6126    // Context menu (4.0).
#define IDM_PROJ_CTX_UNZIP          6127    // Context menu (4.0).
#define IDM_PROJ_CTX_SETACTIVE      6128    // Context menu (4.0).
#define IDM_PROJ_CTX_MAKEALLPREQS   6129    // Context menu (4.0).
#define IDM_PROJ_CTX_SORTFUNCS      6130    // Context menu (4.0).
#define IDM_PROJ_CTX_SETTINGS       6131    // Context menu (4.0).
#define IDM_PROJ_CTX_PROPERTIES     6132    // Context menu (4.0).
#define IDM_PROJ_CTX_BUILD          6133    // Context menu (4.0).
#define IDM_PROJ_CTX_REBUILD        6134    // Context menu (4.0) (5.0: IDM_PROJ_CTX_FORCEBUILD -> IDM_PROJ_CTX_REBUILD).
#define IDM_PROJ_CTX_EXECUTE        6135    // Context menu (4.0).
#define IDM_PROJ_CTX_DEBUG          6136    // Context menu (4.0).
#define IDM_PROJ_CTX_MAKETARGPREQS  6137    // Context menu (4.0).
#define IDM_PROJ_CTX_TOGGLEPANE     6138    // Context menu (4.0).
#define IDM_PROJ_CTX_PROFILE        6139    // Context menu (6.50).
#define IDM_PROJ_CTX_MAKEWKSPREQS   6140    // Context menu (7.0).
#define IDM_PROJ_CTX_CLEAN          6141    // Project menu (7.0).
#define IDM_PROJ_CTX_CLEANWKS       6142    // Project menu (7.0).
#define IDM_PROJ_ADDIN              6143    // (placeholder, never used)
#define IDM_PROJ_ADDIN_CTX          6144    // (placeholder, never used)
//
// Tools window.
//
#define IDM_TOOL_CUSTOMIZE          6145
#define IDM_TOOL_SETTINGS           6146
#define IDM_TOOL_CUSTOMTOOL         6147    // room for 16 tools.
#define IDM_TOOL_CUSTOMTOOL_1       6148    // (placeholder, never used)
#define IDM_TOOL_CUSTOMTOOL_2       6149    // (placeholder, never used)
#define IDM_TOOL_CUSTOMTOOL_3       6150    // (placeholder, never used)
#define IDM_TOOL_CUSTOMTOOL_4       6151    // (placeholder, never used)
#define IDM_TOOL_CUSTOMTOOL_5       6152    // (placeholder, never used)
#define IDM_TOOL_CUSTOMTOOL_6       6153    // (placeholder, never used)
#define IDM_TOOL_CUSTOMTOOL_7       6154    // (placeholder, never used)
#define IDM_TOOL_CUSTOMTOOL_8       6155    // (placeholder, never used) (5.0)
#define IDM_TOOL_CUSTOMTOOL_9       6156    // (placeholder, never used) (5.0)
#define IDM_TOOL_CUSTOMTOOL_10      6157    // (placeholder, never used) (5.0)
#define IDM_TOOL_CUSTOMTOOL_11      6158    // (placeholder, never used) (5.0)
#define IDM_TOOL_CUSTOMTOOL_12      6159    // (placeholder, never used) (5.0)
#define IDM_TOOL_CUSTOMTOOL_13      6160    // (placeholder, never used) (5.0)
#define IDM_TOOL_CUSTOMTOOL_14      6161    // (placeholder, never used) (5.0)
#define IDM_TOOL_CUSTOMTOOL_15      6162    // (placeholder, never used) (5.0)
//
// Window menu.
//
#define IDM_WIN_NEW                 6163
#define IDM_WIN_CASCADE             6164
#define IDM_WIN_TILEVERT            6165
#define IDM_WIN_TILEHORZ            6166
#define IDM_WIN_CLOSEALL            6167
//
// Help menu.
//
#define IDM_HELP_CONTENTS           6168
#define IDM_HELP_CUSTOM             6169    // (placeholder, never used) (5.0)
#define IDM_HELP_WEB_FORUM          6170    // 3.0
#define IDM_HELP_WEB_SOURCECODE     6171    // 3.0
#define IDM_HELP_WEB_ADDIN          6172    // (placeholder, never used)
#define IDM_HELP_ABOUT              6173
#define IDM_HELP_CUSTOMHELP         6174    // room for 16 help files.
#define IDM_HELP_CUSTOMHELP_1       6175    // (placeholder, never used)
#define IDM_HELP_CUSTOMHELP_2       6176    // (placeholder, never used)
#define IDM_HELP_CUSTOMHELP_3       6177    // (placeholder, never used)
#define IDM_HELP_CUSTOMHELP_4       6178    // (placeholder, never used)
#define IDM_HELP_CUSTOMHELP_5       6179    // (placeholder, never used)
#define IDM_HELP_CUSTOMHELP_6       6180    // (placeholder, never used)
#define IDM_HELP_CUSTOMHELP_7       6181    // (placeholder, never used)
#define IDM_HELP_CUSTOMHELP_8       6182    // (placeholder, never used) (5.0)
#define IDM_HELP_CUSTOMHELP_9       6183    // (placeholder, never used) (5.0)
#define IDM_HELP_CUSTOMHELP_10      6184    // (placeholder, never used) (5.0)
#define IDM_HELP_CUSTOMHELP_11      6185    // (placeholder, never used) (5.0)
#define IDM_HELP_CUSTOMHELP_12      6186    // (placeholder, never used) (5.0)
#define IDM_HELP_CUSTOMHELP_13      6187    // (placeholder, never used) (5.0)
#define IDM_HELP_CUSTOMHELP_14      6188    // (placeholder, never used) (5.0)
#define IDM_HELP_CUSTOMHELP_15      6189    // (placeholder, never used) (5.0)
#define IDM_HELP_ADDIN              6190    // (placeholder, never used)
//
// Image/Dialog/Resource/Animation/Source/Debug/Web/Difference window.
//
#define IDM_IMG_NEWIMAGE            6191
#define IDM_IMG_DELETEIMAGE         6192
#define IDM_IMG_RESIZE              6193    // 5.0
#define IDM_IMG_MIRROR_HORZ         6194
#define IDM_IMG_MIRROR_VERT         6195
#define IDM_IMG_ROTATE              6196
#define IDM_IMG_GRAYSCALE           6197
#define IDM_IMG_SEPIATONE           6198    // 4.0
#define IDM_IMG_HSV                 6199
#define IDM_IMG_OPAQUEALPHA         6200    // 4.0
#define IDM_IMG_EFFECT_OILPAINT     6201
#define IDM_IMG_EFFECT_SPREAD       6202
#define IDM_IMG_EFFECT_EMBOSS       6203
#define IDM_IMG_EFFECT_FISHEYE      6204
#define IDM_IMG_EFFECT_DROPSHADOW   6205    // 4.0
#define IDM_IMG_EFFECT_BLUR         6206
#define IDM_IMG_EFFECT_SHARPEN      6207
//
#define IDM_DLG_NEWPICTURE          6208    // 4.50
#define IDM_DLG_NEWTEXT             6209    // 4.50
#define IDM_DLG_NEWEDITBOX          6210    // 4.50
#define IDM_DLG_NEWGROUPBOX         6211    // 4.50
#define IDM_DLG_NEWPUSHBUTTON       6212    // 4.50
#define IDM_DLG_NEWCHECKBOX         6213    // 4.50
#define IDM_DLG_NEWRADIOBUTTON      6214    // 4.50
#define IDM_DLG_NEWCOMBOBOX         6215    // 4.50
#define IDM_DLG_NEWLISTBOX          6216    // 4.50
#define IDM_DLG_NEWHSCROLLBAR       6217    // 4.50
#define IDM_DLG_NEWVSCROLLBAR       6218    // 4.50
#define IDM_DLG_NEWUPDOWN           6219    // 4.50
#define IDM_DLG_NEWPROGRESS         6220    // 4.50
#define IDM_DLG_NEWTRACKBAR         6221    // 4.50
#define IDM_DLG_NEWHOTKEY           6222    // 4.50
#define IDM_DLG_NEWLISTVIEW         6223    // 4.50
#define IDM_DLG_NEWTREEVIEW         6224    // 4.50
#define IDM_DLG_NEWTABCONTROL       6225    // 4.50
#define IDM_DLG_NEWANIMATE          6226    // 4.50
#define IDM_DLG_NEWRICHEDIT         6227    // 4.50
#define IDM_DLG_NEWRICHED20         6228    // 4.50
#define IDM_DLG_NEWDATETIME         6229    // 4.50
#define IDM_DLG_NEWMONTHCAL         6230    // 4.50
#define IDM_DLG_NEWCOMBOBOXEX       6231    // 4.50
#define IDM_DLG_NEWREBAR            6232    // 4.50
#define IDM_DLG_NEWPAGER            6233    // 4.50
#define IDM_DLG_NEWTOOLBAR          6234    // 4.50
#define IDM_DLG_NEWSTATUSBAR        6235    // 4.50
#define IDM_DLG_NEWSYSLINK          6236    // 5.0
#define IDM_DLG_NEWIPADDRESS        6237    // 5.0
#define IDM_DLG_NEWNETADDRESS       6238    // 5.0
#define IDM_DLG_NEWSPLITBUTTON      6239    // 5.0
#define IDM_DLG_NEWCOMMANDLINK      6240    // 5.0
#define IDM_DLG_NEWNATIVEFONT       6241    // 5.0
#define IDM_DLG_ALIGN               6242
#define IDM_DLG_ALIGNLEFT           6243
#define IDM_DLG_ALIGNVERT           6244
#define IDM_DLG_ALIGNRIGHT          6245
#define IDM_DLG_ALIGNTOP            6246
#define IDM_DLG_ALIGNHORZ           6247
#define IDM_DLG_ALIGNBOTTOM         6248
#define IDM_DLG_CENTER              6249
#define IDM_DLG_CENTERVERT          6250
#define IDM_DLG_CENTERHORZ          6251
#define IDM_DLG_SPACE               6252
#define IDM_DLG_SPACEVERT           6253
#define IDM_DLG_SPACEHORZ           6254
#define IDM_DLG_ARRSIZE             6255
#define IDM_DLG_ARRSIZEWIDTH        6256
#define IDM_DLG_ARRSIZEHEIGHT       6257
#define IDM_DLG_ARRSIZEBOTH         6258
#define IDM_DLG_ARRPUSH             6259
#define IDM_DLG_ARRPUSHBOTTOM       6260
#define IDM_DLG_ARRPUSHRIGHT        6261
#define IDM_DLG_SIZETOTEXT          6262
#define IDM_DLG_SORTNAMES           6263
#define IDM_DLG_SORTPROPS           6264
#define IDM_DLG_PROPDESCRIPTION     6265
#define IDM_DLG_RAWSTYLES           6266    // 4.0
#define IDM_DLG_HIDEPROPS           6267
#define IDM_DLG_NEWCUSTOM           6268
#define IDM_DLG_OPENCUSTOM          6269
#define IDM_DLG_REMOVECUSTOM        6270
#define IDM_DLG_LOCKCONTROLS        6271
#define IDM_DLG_ORDERCONTROLS       6272
//
#define IDM_RSRC_NEWBITMAP          6273
#define IDM_RSRC_NEWICON            6274
#define IDM_RSRC_NEWCURSOR          6275
#define IDM_RSRC_NEWANICURSOR       6276
#define IDM_RSRC_NEWVIDEO           6277
#define IDM_RSRC_NEWDIALOG          6278
#define IDM_RSRC_NEWMENU            6279
#define IDM_RSRC_NEWSTRINGTABLE     6280
#define IDM_RSRC_NEWMSGTABLE        6281    // 3.0
#define IDM_RSRC_NEWACCEL           6282
#define IDM_RSRC_NEWVERSION         6283
#define IDM_RSRC_NEWMANIFEST        6284
#define IDM_RSRC_NEWHTML            6285    // 5.0
#define IDM_RSRC_NEWCUSTOM          6286    // 3.0
#define IDM_RSRC_NEWCOPY            6287
#define IDM_RSRC_IMPORT             6288
#define IDM_RSRC_EXPORT             6289    // 6.0
#define IDM_RSRC_SORTNAMES          6290
#define IDM_RSRC_LABELS             6291    // 6.50: IDM_VIEW_LABELS -> IDM_RSRC_LABELS
#define IDM_RSRC_INCLUDES           6292    // 6.50: IDM_VIEW_INCLUDES -> IDM_RSRC_INCLUDES
#define IDM_RSRC_ADDIN              6293    // 3.0 (placeholder, never used)
#define IDM_RSRC_NEW_ADDIN          6294    // 3.0 (placeholder, never used)
//
#define IDM_ANIM_IMPORT             6295
//
#define IDM_MESS_SETINCLUDE         6296    // 3.0
#define IDM_MESS_VIEWLABELS         6297    // 3.0
#define IDM_MESS_ADDIN              6298    // 3.0 (placeholder, never used)
//
#define IDM_SRC_FORCECALLTIP        6299    // 4.50
#define IDM_SRC_COMPLETEWORD        6300
#define IDM_SRC_INSERTSNIPPET       6301    // 5.0
#define IDM_SRC_SURROUNDBYPOPUP     6302    // 5.0
#define IDM_SRC_SURROUNDBY          6303    // 5.0 - room for 16 snippets.
#define IDM_SRC_SURROUNDBY_1        6304    // 5.0 (placeholder, never used)
#define IDM_SRC_SURROUNDBY_2        6305    // 5.0 (placeholder, never used)
#define IDM_SRC_SURROUNDBY_3        6306    // 5.0 (placeholder, never used)
#define IDM_SRC_SURROUNDBY_4        6307    // 5.0 (placeholder, never used)
#define IDM_SRC_SURROUNDBY_5        6308    // 5.0 (placeholder, never used)
#define IDM_SRC_SURROUNDBY_6        6309    // 5.0 (placeholder, never used)
#define IDM_SRC_SURROUNDBY_7        6310    // 5.0 (placeholder, never used)
#define IDM_SRC_SURROUNDBY_8        6311    // 5.0 (placeholder, never used)
#define IDM_SRC_SURROUNDBY_9        6312    // 5.0 (placeholder, never used)
#define IDM_SRC_SURROUNDBY_10       6313    // 5.0 (placeholder, never used)
#define IDM_SRC_SURROUNDBY_11       6314    // 5.0 (placeholder, never used)
#define IDM_SRC_SURROUNDBY_12       6315    // 5.0 (placeholder, never used)
#define IDM_SRC_SURROUNDBY_13       6316    // 5.0 (placeholder, never used)
#define IDM_SRC_SURROUNDBY_14       6317    // 5.0 (placeholder, never used)
#define IDM_SRC_SURROUNDBY_15       6318    // 5.0 (placeholder, never used)
#define IDM_SRC_UCASE               6319
#define IDM_SRC_LCASE               6320
#define IDM_SRC_TABTOSPACE          6321
#define IDM_SRC_SPACETOTAB          6322
#define IDM_SRC_FORMAT              6323    // 3.0
#define IDM_SRC_COMMENT             6324    // 4.0
#define IDM_SRC_UNCOMMENT           6325    // 4.0
#define IDM_SRC_NEXTBOOKMARK        6326
#define IDM_SRC_PREVBOOKMARK        6327
#define IDM_SRC_SETBOOKMARK         6328
#define IDM_SRC_CLEARBOOKMARKS      6329
#define IDM_SRC_WHITESPACE          6330
#define IDM_SRC_LINEBREAKS          6331
#define IDM_SRC_LINENUMBERS         6332
#define IDM_SRC_FOLDINGS            6333
#define IDM_SRC_MATCHINGBRACES      6334    // 4.50
#define IDM_SRC_OPENINCLUDE         6335    // 4.50
#define IDM_SRC_CONTEXTHELP         6336
#define IDM_SRC_VIEWDEFINITION      6337
#define IDM_SRC_PREVDEFINITION      6338
#define IDM_SRC_FINDCALLSITES       6339    // 4.0
#define IDM_SRC_FOLDALL             6340
#define IDM_SRC_UNFOLDALL           6341
#define IDM_SRC_ADDIN               6342    // (placeholder, never used)
#define IDM_SRC_ADDIN_CONV          6343    // (placeholder, never used)
//
#define IDM_DBG_GO                  6344
#define IDM_DBG_RESTART             6345
#define IDM_DBG_STOP                6346
#define IDM_DBG_BREAK               6347
#define IDM_DBG_STEPINTO            6348
#define IDM_DBG_STEPOVER            6349
#define IDM_DBG_STEPOUT             6350    // 4.0
#define IDM_DBG_RUNTOCURSOR         6351    // 4.0
#define IDM_DBG_TOGGLEBREAKPOINT    6352    // 4.0
#define IDM_DBG_EDITBREAKPOINT      6353    // 4.0
#define IDM_DBG_REMOVEBREAKPOINT    6354    // 4.0
#define IDM_DBG_REMOVEBREAKPOINTS   6355    // 4.0
#define IDM_DBG_SHOWNEXTSTMT        6356
#define IDM_DBG_SHOWDISASM          6357
#define IDM_DBG_SHOWSOURCE          6358
#define IDM_DBG_SHOWCODEBYTES       6359
#define IDM_DBG_SHOWSYMBOLS         6360
#define IDM_DBG_ADDWATCH            6361
#define IDM_DBG_REMOVEWATCH         6362
#define IDM_DBG_REMOVEALLWATCHES    6363
#define IDM_DBG_QUICKWATCH          6364    // 4.0
#define IDM_DBG_HWBREAKS            6365    // 4.0
#define IDM_DBG_HEXVALUES           6366    // 4.50
#define IDM_DBG_CPU                 6367    // 5.0
#define IDM_DBG_FPU                 6368    // 5.0
#define IDM_DBG_MMX                 6369    // 5.0
#define IDM_DBG_SSE                 6370    // 5.0
#define IDM_DBG_AVX                 6371    // 7.0 (disabled), 8.0 (supported)
#define IDM_DBG_CPUSEG              6372    // 9.0
#define IDM_DBG_AVX512              6373    // 10.0
#define IDM_DBG_TOGGLESUSPENDED     6374    // 6.50
#define IDM_DBG_COPYNAME            6375    // 12.0
#define IDM_DBG_COPYFILENAME        6376    // 12.0
#define IDM_DBG_COPYDBGFILE         6377    // 12.0
#define IDM_DBG_COPYADDRESS         6378    // 12.0
#define IDM_DBG_ADDIN               6379    // (placeholder, never used)
//
#define IDM_WEB_BACK                6380    // 7.0
#define IDM_WEB_FORWARD             6381    // 7.0
#define IDM_WEB_HOME                6382    // 8.0
#define IDM_WEB_REFRESH             6383    // 7.0
#define IDM_WEB_CERTIFICATE         6384    // 7.0
#define IDM_WEB_SHOWSOURCE          6385    // 7.0
#define IDM_WEB_ZOOM_SMALLEST       6386    // 7.0
#define IDM_WEB_ZOOM_SMALLER        6387    // 7.0
#define IDM_WEB_ZOOM_MEDIUM         6388    // 7.0
#define IDM_WEB_ZOOM_LARGER         6389    // 7.0
#define IDM_WEB_ZOOM_LARGEST        6390    // 7.0
#define IDM_WEB_ADDIN               6391    // (placeholder, never used)
//
#define IDM_DIFF_PREVCHANGE         6392    // 7.0
#define IDM_DIFF_NEXTCHANGE         6393    // 7.0
#define IDM_DIFF_REFRESH            6394    // 7.0
#define IDM_DIFF_STOP               6395    // 7.0
#define IDM_DIFF_OPENLEFT           6396    // 7.0
#define IDM_DIFF_OPENRIGHT          6397    // 7.0
#define IDM_DIFF_OPENCOMPOSITE      6398    // 9.0
#define IDM_DIFF_ADDIN              6399    // (placeholder, never used)
//
// Misc commands.
//
#define IDM_MISC_OPEN               6400
#define IDM_MISC_TEST               6401
#define IDM_MISC_CHECKMNEMONICS     6402
#define IDM_MISC_NEXTWINDOW         6403
#define IDM_MISC_MODEPOPUP          6404    // 10.0
#define IDM_MISC_KILLPROCESS        6405
#define IDM_MISC_CLOSEALLOTHER      6406    // 12.0
//
// Drag & drop menu.
//
#define IDM_DROP_MOVE               6407
#define IDM_DROP_COPY               6408
#define IDM_DROP_CANCEL             6409
//
// Add-in commands (internal).
//
#define IDM_ADDIN_COMMAND           6410
// Range to: IDM_ADDIN_COMMAND + CMAXADDINS - 1

//
// Dialog ID's --------------------------------------------------------------
//

#define DLG_SPLASH              1001
#define DLG_ABOUT               1002
#define DLG_MAINRIBBON          1003    // 9.0
#define DLG_PROJECTRIBBON       1004
#define DLG_FORMRIBBON          1005
#define DLG_MENURIBBON          1006
#define DLG_DRAWRIBBON          1007    // 10.0: DLG_PICTRIBBON -> DLG_DRAWRIBBON
#define DLG_ANIMRIBBON          1008
#define DLG_MEMRIBBON           1009
#define DLG_WEBRIBBON           1010    // 7.0
#define DLG_HELPRIBBON          1011    // 8.0
#define DLG_DIFFRIBBON          1012    // 7.0
#define DLG_NEWPROJECT          1013
#define DLG_NEWDEFPROJECT       1014    // 4.0
#define DLG_NEWICONIMAGE        1015
#define DLG_NEWCURSORIMAGE      1016
#define DLG_NEWCUSTOMIMAGE      1017    // 6.0
#define DLG_PROPSFILE           1018
#define DLG_PROPSSOURCE         1019
#define DLG_PROPSPROJ           1020    // 5.0
#define DLG_PROPSCMDS           1021
#define DLG_PROPSPREQS          1022
#define DLG_PROPSBITMAP         1023
#define DLG_PROPSBITMAP_BMP     1024    // 12.0
#define DLG_PROPSBITMAP_GIF     1025    // 12.0
#define DLG_PROPSBITMAP_PNG     1026    // 12.0
#define DLG_PROPSICONCURSOR     1027
#define DLG_PROPSRSRC           1028
#define DLG_PROPSRSRC2          1029    // 5.0
#define DLG_PROPSSTRING         1030
#define DLG_PROPSMESSAGE        1031    // 3.0
#define DLG_PROPSMENU           1032
#define DLG_PROPSACCEL          1033
#define DLG_PROPSACON           1034
#define DLG_PROPSVIDEO          1035
#define DLG_PROPSPROF           1036    // 6.50
#define DLG_SETUPGENERAL        1037
#define DLG_SETUPCOLORFONT      1038    // 10.0
#define DLG_SETUPSTARTUP        1039    // 10.0
#define DLG_SETUPWEB            1040    // 7.0
#define DLG_SETUPPROJECT        1041    // 7.0
#define DLG_SETUPFOLDERS        1042
#define DLG_SETUPBROWSE         1043    // 10.0
#define DLG_SETUPZIP            1044    // 10.0
#define DLG_SETUPDEBUG          1045
#define DLG_SETUPDEBUGJIT       1046    // 12.0
#define DLG_SETUPDEBUGTRACE     1047    // 12.0
#define DLG_SETUPPROFILE        1048    // 10.0
#define DLG_SETUPSOURCE         1049
#define DLG_SETUPSOURCEC        1050    // 13.0
#define DLG_SETUPSOURCEASM      1051    // 13.0
#define DLG_SETUPSOURCERC       1052    // 13.0
#define DLG_SETUPSOURCEPIS      1053    // 13.0
#define DLG_SETUPRESOURCE       1054    // 10.0
#define DLG_SETUPDIALOG         1055
#define DLG_SETUPIMAGE          1056
#define DLG_SETUPIMAGEJPG       1057    // 10.0
#define DLG_SETUPIMAGEPNG       1058    // 10.0
#define DLG_SETUPADDINS         1059
#define DLG_SETUPSYSDEFS        1060    // 5.0
#define DLG_PROJGENERAL         1061    // 10.0
#define DLG_PROJMACROS          1062    // 10.0
#define DLG_PROJFOLDERS         1063    // 10.0
#define DLG_PROJZIP             1064    // 10.0
#define DLG_PROJSYMBOLS         1065    // 10.0
#define DLG_PROJCOMPILER1       1066    // 10.0
#define DLG_PROJCOMPILER2       1067    // 10.0
#define DLG_PROJASSEMBLER       1068    // 10.0
#define DLG_PROJRESCOMPILER     1069    // 10.0
#define DLG_PROJMSGCOMPILER     1070    // 10.0
#define DLG_PROJLINKER1         1071    // 10.0
#define DLG_PROJLINKER2         1072    // 10.0
#define DLG_PROJLIBRARIAN       1073    // 10.0
#define DLG_PROJINSTBUILDER     1074    // 10.0
#define DLG_PROJSIGNER          1075    // 10.0
#define DLG_PRINT               1076
#define DLG_FIND                1077
#define DLG_REPLACE             1078
#define DLG_FILEFIND            1079
#define DLG_GOTOLINE            1080
#define DLG_GOTOFUNCTION        1081
#define DLG_RSRCLABELS          1082
#define DLG_RSRCINCLUDES        1083
#define DLG_CUSTOMTOOLS         1084
#define DLG_TOOL                1085
#define DLG_CUSTOMHELP          1086
#define DLG_HELP                1087
#define DLG_CUSTOMKEYS          1088
#define DLG_ADDINS              1089
#define DLG_SNIPPETS            1090    // 5.0
#define DLG_SNIPPET             1091    // 5.0
#define DLG_CUSTOMRESOURCE      1092    // 3.0
#define DLG_DUPRESOURCE         1093
#define DLG_PROJMACRO           1094
#define DLG_NEWCUSTOM           1095
#define DLG_REMOVECUSTOM        1096
#define DLG_SELECTCUSTOM        1097
#define DLG_COLORPAL            1098    // 4.0
#define DLG_COLORHSV            1099    // 4.0
#define DLG_RESIZEIMAGE         1100    // 5.0
#define DLG_ROTATEIMAGE         1101
#define DLG_OILPAINTIMAGE       1102
#define DLG_SPREADIMAGE         1103
#define DLG_FISHEYEIMAGE        1104
#define DLG_DROPSHADOWIMAGE     1105    // 4.0
#define DLG_HSVIMAGE            1106
#define DLG_DRAWTEXT            1107
#define DLG_FORMTEXT            1108    // 5.0
#define DLG_MENUTEST            1109
#define DLG_TYPEDKEY            1110
#define DLG_SELECTPROJECT       1111    // 4.0
#define DLG_PROJECTDEPS         1112    // 4.0
#define DLG_PROJECTMODES        1113    // 9.0
#define DLG_NEWPROJMODE         1114    // 9.0
#define DLG_EXTRACTZIP          1115
#define DLG_BROWSEINFO          1116
#define DLG_SELECTSNIPPET       1117    // 5.0
#define DLG_EDITBREAK           1118    // 4.0
#define DLG_ADDWATCH            1119
#define DLG_QUICKWATCH          1120    // 4.0
#define DLG_HWBREAKS            1121    // 4.0
#define DLG_EFLAGS              1122
#define DLG_CONTROLWORD         1123
#define DLG_STATUSWORD          1124
#define DLG_TAGWORD             1125
#define DLG_MXCSR               1126
#define DLG_RUNEXE              1127    // 5.0; 6.50: DLG_DEBUGEXE -> DLG_RUNEXE

//
// Dialog control ID's ------------------------------------------------------
//

#define DID_ABOUT1              4001
#define DID_ABOUT2              4002
#define DID_ABOUT3              4003
#define DID_ABOUT4              4004
#define DID_ABOUT5              4005
#define DID_MODELIST            4006    // DLG_MAINRIBBON
#define DID_IMAGELIST           4007    // DLG_DRAWRIBBON
#define DID_HOTSPOT             4008
#define DID_HOTSPOTLABEL        4009
#define DID_ACONFRAME           4010
#define DID_ACONRATE            4011
#define DID_ACONRATESPIN        4012
#define DID_ACONTITLE           4013
#define DID_ACONARTIST          4014
#define DID_ACONFRAMES          4015
#define DID_ACONSTEPS           4016
#define DID_ACONRATEDEF         4017
#define DID_OPENASLIST          4018    // 4.50
#define DID_NEWPROJLIST         4019
#define DID_NEWPROJVIEW         4020
#define DID_PROJNAME            4021
#define DID_PROJPATH            4022
#define DID_ADVANCED            4023    // 6.0
#define DID_OUTPUTPATH          4024    // 6.0
#define DID_OUTPUTPATHLABEL     4025    // 6.0
#define DID_RESULTPATH          4026    // 6.0
#define DID_RESULTPATHLABEL     4027    // 6.0
#define DID_NEWWORKSPACE        4028    // 4.0
#define DID_ADDTOWORKSPACE      4029    // 4.0
#define DID_NEWIMAGELIST        4030    // Both Icon and Cursor. Must be!
#define DID_CUSTOMCLASS         4031
#define DID_CUSTOMSTYLE         4032
#define DID_CUSTOMEXSTYLE       4033
#define DID_CUSTOMWIDTH         4034
#define DID_CUSTOMHEIGHT        4035
#define DID_CUSTOMTEXT          4036
#define DID_FILENAME            4037
#define DID_FILEPATH            4038
#define DID_FILESIZE            4039
#define DID_REALFILESIZE        4040    // 8.0
#define DID_FILEICON            4041
#define DID_FILEMESSAGE         4042    // 5.0
#define DID_TIME_CREATED        4043
#define DID_TIME_CHANGED        4044
#define DID_TIME_TOUCHED        4045
#define DID_ATTR_ARCHIVE        4046
#define DID_ATTR_READONLY       4047
#define DID_ATTR_HIDDEN         4048
#define DID_ATTR_SYSTEM         4049
#define DID_LANGUAGE            4050
#define DID_CRBREAK             4051
#define DID_LFBREAK             4052
#define DID_ENCODING            4053    // 5.0
#define DID_ENCODING2           4054    // 5.0
#define DID_ENCODING3           4055    // 5.0
#define DID_CTRLCHARS           4056
#define DID_SHELLCOMMANDS       4057
#define DID_MACROLIST           4058
#define DID_MACRONAME           4059
#define DID_MACROVALUE          4060
#define DID_PREQSLIST           4061
#define DID_PROJTYPELABEL       4062    // 10.0
#define DID_PROJTYPE            4063    // 10.0
#define DID_IMAGEWIDTH          4064
#define DID_IMAGEHEIGHT         4065
#define DID_IMAGECOLORS         4066
#define DID_COMPRESSEDFILE      4067
#define DID_TRANSPARENCY        4068    // 5.0
#define DID_XORMASK             4069
#define DID_ANDMASK             4070
#define DID_SCREENWIDTH         4071    // 12.0 (GIF)
#define DID_SCREENHEIGHT        4072    // 12.0 (GIF)
#define DID_SCREENLEFT          4073    // 12.0 (GIF)
#define DID_SCREENTOP           4074    // 12.0 (GIF)
#define DID_DELAYTIME           4075    // 12.0 (GIF)
#define DID_DELAYTIMESPIN       4076    // 12.0 (GIF)
#define DID_REPETITIONS         4077    // 12.0 (GIF)
#define DID_DISPOSALMETHOD      4078    // 12.0 (GIF)
#define DID_INTERLACED          4079    // 12.0 (GIF)
#define DID_RSRCID              4080
#define DID_RSRCLANGUAGE        4081
#define DID_RSRCFILENAME        4082    // 4.0
#define DID_RSRCTYPE            4083    // 3.0
#define DID_STRINGID            4084
#define DID_STRINGTEXT          4085
#define DID_MSGID               4086    // 3.0
#define DID_MSGCODE             4087    // 3.0
#define DID_MSGFACILITY         4088    // 3.0
#define DID_MSGSEVERITY         4089    // 3.0
#define DID_MSGCUSTOMER         4090    // 3.0
#define DID_MSGTEXT             4091    // 3.0
#define DID_MSGANSI             4092    // 3.0
#define DID_MSGUTF16            4093    // 3.0
#define DID_MSGUTF8             4094    // 13.00
#define DID_MENUID              4095
#define DID_MENUTEXT            4096
#define DID_MENUPOPUP           4097
#define DID_MENUSEPARATOR       4098
#define DID_MENUDEFAULT         4099
#define DID_MENUGRAYED          4100
#define DID_MENUCHECKED         4101
#define DID_MENURADIOCHECK      4102
#define DID_MENUBREAK           4103
#define DID_ACCELID             4104
#define DID_ACCELKEY            4105
#define DID_ACCELCTRL           4106
#define DID_ACCELALT            4107
#define DID_ACCELSHIFT          4108
#define DID_ACCELASCII          4109
#define DID_ACCELVIRTKEY        4110
#define DID_VIDEORATE           4111
#define DID_VIDEORATESPIN       4112
#define DID_FRAMERATE           4113
#define DID_FRAMERATESPIN       4114
#define DID_TRANSPARENT         4115
#define DID_CODEC               4116
#define DID_FUNCSAMPLES         4117    // 6.50
#define DID_PROFSAMPLES         4118    // 6.50
#define DID_VOIDSAMPLES         4119    // 6.50
#define DID_SHOWSPLASH          4120
#define DID_ONSTARTUP           4121    // 7.0
#define DID_SHOWPATH            4122
#define DID_AUTORELOAD          4123    // 6.0
#define DID_MAXFILESIZE         4124    // 11.0
#define DID_UNIQUERSRCIDENTS    4125    // 4.0
#define DID_MOUSELINES          4126
#define DID_MOUSELINESSPIN      4127
#define DID_CARETWIDTH          4128    // 12.0
#define DID_CARETWIDTHSPIN      4129    // 12.0
#define DID_THEME               4130    // 10.0
#define DID_CATEGORIES          4131    // 10.0
#define DID_COLORLIST           4132
#define DID_FORECOLOR           4133
#define DID_BACKCOLOR           4134
#define DID_FONTFACE            4135
#define DID_FONTSIZE            4136
#define DID_BROWSEINFO          4137
#define DID_BROWSELEVEL1        4138
#define DID_BROWSELEVEL2        4139
#define DID_CALLTIPS            4140
#define DID_INFOTIPS            4141    // 9.0
#define DID_MEMBERLIST          4142
#define DID_INCLUDELIST         4143    // 6.50
#define DID_DRAGDROP            4144
#define DID_WRAPFINDQUERY       4145
#define DID_MAKEBACKUP          4146
#define DID_TABSIZE             4147
#define DID_INDENTSIZE          4148    // 4.50
#define DID_USETABS             4149    // 3.0
#define DID_SPACETABS           4150    // 3.0
#define DID_INDENTNONE          4151    // 3.0
#define DID_INDENTBLOCK         4152    // 3.0
#define DID_INDENTSMART         4153    // 3.0
#define DID_STRUCTBRACE         4154    // 12.0
#define DID_ENUMBRACE           4155    // 12.0
#define DID_FUNCBRACE           4156    // 12.0
#define DID_STMTBRACE           4157    // 12.0
#define DID_STMTSPACE           4158    // 12.0
#define DID_OPORSPACE           4159    // 12.0
#define DID_PARENSPACE          4160    // 12.0
#define DID_CALLSPACE           4161    // 12.0
#define DID_ELSECUDDLE          4162    // 12.0
#define DID_DOCUDDLE            4163    // 12.0
#define DID_CASEINDENT          4164    // 12.0
#define DID_TRIMBLANKS          4165    // 12.0
#define DID_AUTOFILESAVE        4166
#define DID_FASTLOADPROJECT     4167    // 3.0
#define DID_PROJPANELEFT        4168    // 7.0
#define DID_PROJPANERIGHT       4169    // 7.0
#define DID_SORTPROJFUNCS       4170    // 7.0
#define DID_AUTOSELECTNEWPROJ   4171    // 7.0
#define DID_ZIPEXTRA            4172    // 7.0
#define DID_UNIQUEZIPNAMES      4173    // 4.0
#define DID_CLEANPROJECTMODE    4174    // 9.0
#define DID_CXFORMGRID          4175
#define DID_CYFORMGRID          4176
#define DID_CXFORMMARGIN        4177
#define DID_CYFORMMARGIN        4178
#define DID_CXCONTROLSPACE      4179
#define DID_CYCONTROLSPACE      4180
#define DID_CXBUTTONSPACE       4181
#define DID_CYBUTTONSPACE       4182
#define DID_FORMGRID            4183
#define DID_PIXELGRID           4184
#define DID_IMAGEGRID           4185
#define DID_CXIMAGEGRID         4186
#define DID_CYIMAGEGRID         4187
#define DID_JPEGQUALITY         4188
#define DID_PNGCOMPRESSION      4189    // 4.0
#define DID_USEDITHER           4190
#define DID_JITDEBUGGER         4191
#define DID_HEXVALUES           4192
#define DID_FLAGSDIALOG         4193
#define DID_BREAKONENTRY        4194    // 4.0
#define DID_MAXARRAYELEMS       4195    // 3.0
#define DID_DBGHELPSYMPATH      4196    // 13.0
#define DID_THREADMSG           4197    // 12.0
#define DID_MODULEMSG           4198    // 12.0
#define DID_OUTPUTMSG           4199    // 12.0
#define DID_DBGHELPMSG          4200    // 13.0
#define DID_PROFRATE            4201    // 6.50
#define DID_PROFRATESPIN        4202    // 6.50
#define DID_ALLMODULES          4203    // 6.50
#define DID_PROFLINES           4204    // 8.0
#define DID_CALLTREE            4205    // 8.0
#define DID_HOMEPAGE            4206    // 7.0
#define DID_FOLDERGROUP         4207
#define DID_FOLDERS             4208
#define DID_ARGUMENTS           4209    // GNRL
#define DID_WORKPATH            4210    // GNRL
#define DID_EXECUTOR            4211    // GNRL
#define DID_PPDEFINE            4212    // CC, RC, AS
#define DID_PPUNDEFINELABEL     4213    // CC, RC
#define DID_PPUNDEFINE          4214    // CC, RC
#define DID_DEBUGINFO           4215    // CC, AS, LINK
#define DID_WARNINGLEVEL        4216    // CC
#define DID_DIAGTYPE            4217    // CC (10.0)
#define DID_CSTANDARD           4218    // CC (7.0)
#define DID_MSEXTENSIONS        4219    // CC
#define DID_EXTENSIONS          4220    // CC
#define DID_OPENMP              4221    // CC (8.0)
#define DID_CHARUNSIGNED        4222    // CC
#define DID_TIME64              4223    // CC (10.0)
#define DID_OVERFLOWTRAP        4224    // CC (7.0)
#define DID_CRTLIB              4225    // CC
#define DID_OPTIMIZATION        4226    // CC
#define DID_OPTIMIZEMORE        4227    // CC (11.0)
#define DID_INLINEMODEL         4228    // CC (6.0)
#define DID_ARCH                4229    // CC (9.0)
#define DID_FPMODEL             4230    // CC (6.0)
#define DID_CALLCONV            4231    // CC, AS
#define DID_OMITDEFAULTLIB      4232    // CC
#define DID_OLDNAMES            4233    // CC
#define DID_NULLTERMINATE       4234    // RC (5.0)
#define DID_MAPFILE             4235    // LINK
#define DID_DBGFILE             4236    // LINK (9.0)
#define DID_NODEFAULTLIB        4237    // LINK
#define DID_RELEASE             4238    // LINK
#define DID_LARGEADDRESSAWARE   4239    // LINK (5.0)
#define DID_SAFESEH             4240    // LINK (9.0)
#define DID_LIBRARIES           4241    // LINK
#define DID_DELAYLOADS          4242    // LINK
#define DID_ENTRYPOINT          4243    // LINK
#define DID_SECTALIGN           4244    // LINK
#define DID_FILEALIGN           4245    // LINK (13.0)
#define DID_STACKRESERVE        4246    // LINK
#define DID_STACKCOMMIT         4247    // LINK
#define DID_VERMAJOR            4248    // LINK
#define DID_VERMINOR            4249    // LINK
#define DID_OSVERMAJOR          4250    // LINK
#define DID_OSVERMINOR          4251    // LINK
#define DID_SUBSYSTEM           4252    // LINK
#define DID_SUBSYSMAJOR         4253    // LINK
#define DID_SUBSYSMINOR         4254    // LINK
#define DID_VERBOSE             4255    // PROJ, RC, MC, LINK, LIB, INST, CAB, SIGN
#define DID_SIGN                4256    // SIGN (5.0)
#define DID_CERTIFICATE         4257    // SIGN (5.0)
#define DID_TIMESTAMPSERVER     4258    // SIGN (5.0)
#define DID_PROGRESS            4259
#define DID_FINDWHAT            4260
#define DID_REPLACEWITH         4261
#define DID_SEARCHUP            4262
#define DID_SEARCHDOWN          4263
#define DID_MATCHCASE           4264
#define DID_WHOLEWORD           4265    // 6.0
#define DID_REGEX               4266    // 11.0
#define DID_FINDSCOPE           4267    // 9.0
#define DID_FINDSCOPELABEL      4268    // 9.0
#define DID_FINDSPEC            4269    // 7.0: DID_FINDFORMAT -> DID_FINDSPEC
#define DID_FINDPATH            4270
#define DID_SUBFOLDERS          4271
#define DID_LINENO              4272
#define DID_ADDRESS             4273
#define DID_FUNCNAME            4274
#define DID_LABELLIST           4275
#define DID_LABELNAME           4276
#define DID_LABELVALUE          4277
#define DID_INCLUDES            4278
#define DID_TOOLS               4279
#define DID_TOOLTEXT            4280
#define DID_TOOLCOMMAND         4281
#define DID_TOOLARGUMENTS       4282
#define DID_TOOLFOLDER          4283
#define DID_TOOLCAPTURE         4284
#define DID_HELPFILES           4285
#define DID_HELPTEXT            4286
#define DID_HELPCOMMAND         4287
#define DID_HELPBUILTIN         4288    // 7.0
#define DID_KEYCATEGORIES       4289
#define DID_KEYCOMMANDS         4290
#define DID_KEYLIST             4291
#define DID_ADDINS              4292
#define DID_ADDINTEXT           4293    // 9.0: stc32 -> DID_ADDINTEXT
#define DID_SNIPPETGROUP        4294    // 5.0
#define DID_SNIPPETS            4295    // 5.0
#define DID_SNIPPETNAME         4296    // 5.0
#define DID_SNIPPETCODE         4297    // 5.0
#define DID_IMPORTASLIST        4298    // 4.50 (from 3.0 radio buttons)
#define DID_CUSTOMLIST          4299
#define DID_CUSTOMSAMPLE        4300
#define DID_RETAINRATIO         4301    // 5.0
#define DID_DEGREES             4302
#define DID_RADIUS              4303
#define DID_AMOUNT              4304
#define DID_CURVATURE           4305
#define DID_OFFSETX             4306    // 4.0
#define DID_OFFSETXSPIN         4307    // 4.0
#define DID_OFFSETY             4308    // 4.0
#define DID_OFFSETYSPIN         4309    // 4.0
#define DID_HUE                 4310
#define DID_HUESPIN             4311    // 5.0
#define DID_SATURATION          4312
#define DID_SATURATIONSPIN      4313    // 5.0
#define DID_BRIGHTNESS          4314
#define DID_BRIGHTNESSSPIN      4315    // 5.0
#define DID_PREVIEW             4316
#define DID_TOOLBAR             4317
#define DID_GENERIC             4318
#define DID_GENERIC2            4319    // 6.0
#define DID_PROJECTLIST         4320    // 4.0
#define DID_DEPENDENCYLIST      4321    // 4.0
#define DID_MODENAME            4322    // 9.0
#define DID_ZIPCOMMENT          4323
#define DID_ZIPFILES            4324
#define DID_BROWSETAGS          4325
#define DID_BREAKONHITCOUNT     4326    // 4.0
#define DID_BREAKCOUNT          4327    // 4.0
#define DID_BREAKONEXPRESSION   4328    // 4.0
#define DID_BREAKEXPRESSION     4329    // 4.0
#define DID_BREAKENABLED        4330    // 4.0
#define DID_WATCHBYLIST         4331    // 4.0
#define DID_WATCHLIST           4332
#define DID_WATCHBYEXPRESSION   4333    // 4.0
#define DID_WATCHEXPRESSION     4334    // 4.0
#define DID_WATCHRESULT         4335    // 4.0
#define DID_HWBREAKTYPE1        4336    // 4.0
#define DID_HWBREAKTYPE2        4337    // 4.0
#define DID_HWBREAKTYPE3        4338    // 4.0
#define DID_HWBREAKTYPE4        4339    // 4.0
#define DID_HWBREAKADDRESS1     4340    // 4.0
#define DID_HWBREAKADDRESS2     4341    // 4.0
#define DID_HWBREAKADDRESS3     4342    // 4.0
#define DID_HWBREAKADDRESS4     4343    // 4.0
#define DID_HWBREAKSIZE1        4344    // 4.0
#define DID_HWBREAKSIZE2        4345    // 4.0
#define DID_HWBREAKSIZE3        4346    // 4.0
#define DID_HWBREAKSIZE4        4347    // 4.0
#define DID_CF                  4348
#define DID_PF                  4349
#define DID_AF                  4350
#define DID_ZF                  4351
#define DID_SF                  4352
#define DID_DF                  4353
#define DID_OF                  4354
#define DID_IM                  4355
#define DID_DM                  4356
#define DID_ZM                  4357
#define DID_OM                  4358
#define DID_UM                  4359
#define DID_PM                  4360
#define DID_PC0                 4361
#define DID_PC1                 4362
#define DID_PC2                 4363
#define DID_PC3                 4364
#define DID_RC0                 4365
#define DID_RC1                 4366
#define DID_RC2                 4367
#define DID_RC3                 4368
#define DID_IE                  4369
#define DID_DE                  4370
#define DID_ZE                  4371
#define DID_OE                  4372
#define DID_UE                  4373
#define DID_PE                  4374
#define DID_STKFAULT            4375
#define DID_ES                  4376
#define DID_TOP                 4377
#define DID_TAG0                4378
#define DID_TAG1                4379
#define DID_TAG2                4380
#define DID_TAG3                4381
#define DID_TAG4                4382
#define DID_TAG5                4383
#define DID_TAG6                4384
#define DID_TAG7                4385
#define DID_DAZ                 4386
#define DID_FZ                  4387
#define DID_PALETTE             4388    // 4.0
#define DID_HSV                 4389    // 4.0
#define DID_RED                 4390    // 4.0
#define DID_REDSPIN             4391    // 5.0
#define DID_GREEN               4392    // 4.0
#define DID_GREENSPIN           4393    // 5.0
#define DID_BLUE                4394    // 4.0
#define DID_BLUESPIN            4395    // 5.0
#define DID_ALPHA               4396    // 4.0
#define DID_ALPHASPIN           4397    // 5.0
#define DID_ALPHALABEL          4398    // 4.0
#define DID_ALPHATRACK          4399    // 4.0
#define DID_ALPHAFRAME          4400    // 4.0
#define DID_PALINDEX            4401    // 6.50
#define DID_URL                 4402    // 7.0
#define DID_LEFT                4403    // 7.0
#define DID_RIGHT               4404    // 7.0
#define DID_DEEP                4405    // 7.0

// Private Button ID's.
#define IDOK                    1       // For help project.
#define IDCANCEL                2       // For help project.
#define IDADD                   21
#define IDCHANGE                22
#define IDDEL                   23
#define IDDEFAULT               24
#define IDREPLACE               25
#define IDREPLACEALL            26
#define IDBROWSE                27
#define IDTYPEDKEY              28
#define IDSETUP                 29
#define IDSYSDEFS               30      // 5.0
#define IDBROWSE2               31      // 7.0
#define IDRENAME                32      // 9.0

//
// Various resource ID's ----------------------------------------------------
//

// Menu ID's.
//
#define IDR_MNU_MAIN            2001
#define IDR_MNU_MODE            2002    // 10.0
#define IDR_MNU_EDIT            2003
#define IDR_MNU_DRAW            2004    // 10.0: IDR_MNU_PICT -> IDR_MNU_DRAW
#define IDR_MNU_FORM            2005
#define IDR_MNU_MENU            2006
#define IDR_MNU_MESS            2007    // 3.0
#define IDR_MNU_RSRC            2008
#define IDR_MNU_DBG             2009
#define IDR_MNU_WEB             2010    // 7.0
#define IDR_MNU_DIFF            2011    // 7.0

#define IDR_CTX_EDIT            2012
#define IDR_CTX_DRAW            2013    // 10.0: IDR_CTX_PICT -> IDR_CTX_DRAW
#define IDR_CTX_FORM            2014
#define IDR_CTX_TEXT            2015
#define IDR_CTX_MESS            2016    // 3.0
#define IDR_CTX_MENU            2017
#define IDR_CTX_ACCL            2018
#define IDR_CTX_VERS            2019
#define IDR_CTX_ANIM            2020
#define IDR_CTX_RSRC            2021
#define IDR_CTX_DUMP            2022
#define IDR_CTX_PROF            2023    // 6.50
#define IDR_CTX_PROJPANE        2024    // 4.0
#define IDR_CTX_PROJSRCWKS      2025    // 4.0
#define IDR_CTX_PROJSRCPROJ     2026    // 4.0
#define IDR_CTX_PROJSRCFILE     2027    // 4.0
#define IDR_CTX_PROJSRCFUNC     2028    // 8.0
#define IDR_CTX_PROJTARGWKS     2029    // 5.0
#define IDR_CTX_PROJTARGPROJ    2030    // 4.0
#define IDR_CTX_PROJTARGFILE    2031    // 4.0
#define IDR_CTX_BUILD           2032
#define IDR_CTX_PROPS           2033
#define IDR_CTX_FILEFIND        2034    // 10.0
#define IDR_CTX_OUTPUT          2035
#define IDR_CTX_TRACE           2036
#define IDR_CTX_DBGSRC          2037
#define IDR_CTX_DBGMIX          2038
#define IDR_CTX_BREAK           2039    // 4.0
#define IDR_CTX_WATCH           2040
#define IDR_CTX_SYMBOL          2041    // 4.50
#define IDR_CTX_MEMORY          2042    // 4.50
#define IDR_CTX_THREAD          2043    // 6.50
#define IDR_CTX_MODULE          2044    // 12.0
#define IDR_CTX_REGS            2045    // 5.0
#define IDR_CTX_DROP            2046
#define IDR_CTX_TABS            2047
#define IDR_CTX_WEB             2048    // 7.0
#define IDR_CTX_DIFFOUTLINE     2049    // 7.0
#define IDR_CTX_DIFFEXPAND      2050    // 7.0

#define IDR_ACC_MAIN            3001

// Bitmap ID's.
//
#define IDR_BMP_SPLASH          8001    // Splash screen.
#define IDR_BMP_BRUSHTYPES      8002
#define IDR_BMP_SELTYPES        8003
#define IDR_BMP_ERASETYPES      8004
#define IDR_BMP_LINETYPES       8005    // 4.0
#define IDR_BMP_SHAPETYPES      8006
#define IDR_BMP_SPRAYTYPES      8007
#define IDR_BMP_ZOOMTYPES       8008
#define IDR_BMP_GRADTYPES       8009    // 5.0
#define IDR_BMP_HANDLE1         8010
#define IDR_BMP_HANDLE2         8011
#define IDR_BMP_HELPTREE        8012    // 7.0
#define IDR_BMP_MDITABS         8013    // 8.0
#define IDR_BMP_HOT_MDITABS     8014    // 8.0
#define IDR_BMP_FONTCUES        8015    // 6.50
#define IDR_BMP_THRDCUES        8016    // 6.50
#define IDR_BMP_BRUSHTYPES_BIG  8017    // 13.0
#define IDR_BMP_SELTYPES_BIG    8018    // 13.0
#define IDR_BMP_ERASETYPES_BIG  8019    // 13.0
#define IDR_BMP_LINETYPES_BIG   8020    // 13.0
#define IDR_BMP_SHAPETYPES_BIG  8021    // 13.0
#define IDR_BMP_SPRAYTYPES_BIG  8022    // 13.0
#define IDR_BMP_ZOOMTYPES_BIG   8023    // 13.0
#define IDR_BMP_GRADTYPES_BIG   8024    // 13.0

// Alpha channel patterns.
#define IDR_BMP_ALPHAZOOM4      8025    // 13.0
#define IDR_BMP_ALPHAZOOM8      8026    // 4.0
#define IDR_BMP_ALPHAZOOM16     8027    // 13.0

// Icon ID's.
//
#define IDR_ICO_MAIN            8028    // Application icon.
#define IDR_ICO_SRCFILE         8029    // Explorer association icon (.c, .asm).
#define IDR_ICO_WRKFILE         8030    // Explorer association icon (.h, .inc, .rc, ...).
#define IDR_ICO_SOURCE          8031
#define IDR_ICO_IMAGE           8032
#define IDR_ICO_DIALOG          8033
#define IDR_ICO_DEBUG           8034
#define IDR_ICO_PROFILE         8035    // 6.50
#define IDR_ICO_STRTABLE        8036
#define IDR_ICO_MSGTABLE        8037    // 3.0
#define IDR_ICO_MENU            8038
#define IDR_ICO_ACCEL           8039
#define IDR_ICO_VERSION         8040
#define IDR_ICO_ANIM            8041
#define IDR_ICO_RESOURCE        8042
#define IDR_ICO_HEXDUMP         8043
#define IDR_ICO_DIFF            8044    // 7.0
#define IDR_ICO_W32APP          8045
#define IDR_ICO_W32DLL          8046
#define IDR_ICO_W32LIB          8047
#define IDR_ICO_W32CON          8048
#define IDR_ICO_W32INST         8049    // 5.0
#define IDR_ICO_W64APP          8050    // 5.0
#define IDR_ICO_W64DLL          8051    // 5.0
#define IDR_ICO_W64LIB          8052    // 5.0
#define IDR_ICO_W64CON          8053    // 5.0
#define IDR_ICO_WIZARD          8054
#define IDR_ICO_CHECK           8055
// Objects and actions.
#define IDR_ICO_OPEN            8056    // 6.50
#define IDR_ICO_SAVE            8057    // 6.50
#define IDR_ICO_SAVEALL         8058    // 6.50
#define IDR_ICO_PRINT           8059    // 6.50
#define IDR_ICO_PROPERTIES      8060    // 6.50

#define IDR_ICO_UNDO            8061    // 6.50
#define IDR_ICO_REDO            8062    // 6.50
#define IDR_ICO_CUT             8063    // 6.50
#define IDR_ICO_COPY            8064    // 6.50
#define IDR_ICO_PASTE           8065    // 6.50
#define IDR_ICO_DELETE          8066    // 6.50
#define IDR_ICO_INSERT          8067    // 6.50
#define IDR_ICO_EDIT            8068    // 6.50
#define IDR_ICO_FIND            8069    // 6.50
#define IDR_ICO_FINDNEXT        8070    // 6.50
#define IDR_ICO_FILEFIND        8071    // 6.50

#define IDR_ICO_TABPAGES        8072    // 6.50
#define IDR_ICO_CASCADE         8073    // 6.50
#define IDR_ICO_TILEHORZ        8074    // 6.50
#define IDR_ICO_TILEVERT        8075    // 6.50
#define IDR_ICO_TOOL            8076    // 6.50
#define IDR_ICO_HELP            8077    // 6.50
#define IDR_ICO_WEB             8078    // 6.50
#define IDR_ICO_USER            8079    // 6.50

#define IDR_ICO_BITMAP          8080    // 6.50
#define IDR_ICO_ICON            8081    // 6.50
#define IDR_ICO_CURSOR          8082    // 6.50
#define IDR_ICO_ANICURSOR       8083    // 6.50
#define IDR_ICO_VIDEO           8084    // 6.50

#define IDR_ICO_ANIICON         8085    // 13.0
#define IDR_ICO_HTML            8086    // 13.0
#define IDR_ICO_MANIFEST        8087    // 13.0
#define IDR_ICO_WAVE            8088    // 13.0
#define IDR_ICO_TYPELIB         8089    // 13.0

#define IDR_ICO_FOLDER          8090    // 6.50
#define IDR_ICO_MOVEUP          8091    // 6.50
#define IDR_ICO_MOVEDOWN        8092    // 6.50
#define IDR_ICO_RENAME          8093    // 6.50

#define IDR_ICO_BACK            8094    // 7.0
#define IDR_ICO_FORWARD         8095    // 7.0
#define IDR_ICO_HOME            8096    // 8.0
#define IDR_ICO_REFRESH         8097    // 7.0
#define IDR_ICO_CERTIFICATE     8098    // 7.0

// Debugger.
#define IDR_ICO_GODEBUG         8099    // 6.50
#define IDR_ICO_RESTART         8100    // 6.50
#define IDR_ICO_BREAK           8101    // 6.50
#define IDR_ICO_STOPDEBUG       8102    // 6.50, 7.0: IDR_ICO_STOP -> IDR_ICO_STOPDEBUG
#define IDR_ICO_STEPINTO        8103    // 6.50
#define IDR_ICO_STEPOVER        8104    // 6.50
#define IDR_ICO_STEPOUT         8105    // 6.50
#define IDR_ICO_QUICKWATCH      8106    // 6.50
#define IDR_ICO_BRKPNT          8107    // 6.50, 13.0: IDR_ICO_TOGGLEBRKPT -> IDR_ICO_BRKPNT
#define IDR_ICO_BRKPNT_EXT      8108    // 13.0
#define IDR_ICO_BRKPNT_OFF      8109    // 13.0
#define IDR_ICO_SHOWNEXTSTMT    8110    // 6.50
// Projects.
#define IDR_ICO_SOURCEFILE      8111    // 6.50
#define IDR_ICO_TARGETFILE      8112    // 6.50
#define IDR_ICO_HEADERFILE      8113    // 13.0
#define IDR_ICO_RESOURCEFILE    8114    // 13.0
#define IDR_ICO_OTHERFILE       8115    // 13.0
#define IDR_ICO_BUILD           8116    // 6.50
#define IDR_ICO_STOPBUILD       8117    // 6.50
#define IDR_ICO_COMPILE         8118    // 6.50
#define IDR_ICO_EXECUTE         8119    // 6.50
#define IDR_ICO_ADDFILE         8120    // 6.50
#define IDR_ICO_ADDPROJ         8121    // 6.50
#define IDR_ICO_ZIP             8122    // 6.50
#define IDR_ICO_UNZIP           8123    // 6.50
#define IDR_ICO_MAKEPREQ        8124    // 6.50
#define IDR_ICO_SETACTIVE       8125    // 6.50
#define IDR_ICO_SETTINGS        8126    // 6.50
#define IDR_ICO_EXCLUDE         8127    // 6.50
#define IDR_ICO_CLOSEPROJ       8128    // 6.50
#define IDR_ICO_VIEWLIST        8129    // 6.50
#define IDR_ICO_VIEWICON        8130    // 6.50
#define IDR_ICO_ADVANCED        8131    // 6.50
#define IDR_ICO_STANDARD        8132    // 6.50
#define IDR_ICO_WORKSPACE       8133    // 13.0
#define IDR_ICO_FUNCTION        8134    // 13.0
#define IDR_ICO_VARIABLE        8135    // 13.0
#define IDR_ICO_STRUCT          8136    // 13.0
#define IDR_ICO_MEMBER          8137    // 13.0
#define IDR_ICO_ENUMER          8138    // 13.0
#define IDR_ICO_ENUM            8139    // 13.0
#define IDR_ICO_DEFINE          8140    // 13.0
#define IDR_ICO_TYPEDEF         8141    // 13.0
// Image editor.
#define IDR_ICO_PENCIL          8142    // 6.50
#define IDR_ICO_BRUSH           8143    // 6.50
#define IDR_ICO_SELECT          8144    // 6.50
#define IDR_ICO_ERASER          8145    // 6.50
#define IDR_ICO_LINE            8146    // 6.50
#define IDR_ICO_RECT            8147    // 6.50
#define IDR_ICO_ELLIPSE         8148    // 6.50
#define IDR_ICO_ROUNDRECT       8149    // 6.50
#define IDR_ICO_FILL            8150    // 6.50
#define IDR_ICO_DRAWTEXT        8151    // 6.50
#define IDR_ICO_SPRAY           8152    // 6.50
#define IDR_ICO_PICKCOLOR       8153    // 6.50
#define IDR_ICO_MAGNIFY         8154    // 6.50
#define IDR_ICO_HOTSPOT         8155    // 6.50
#define IDR_ICO_GRADIENT        8156    // 6.50
#define IDR_ICO_PALETTE         8157    // 6.50
#define IDR_ICO_OPENPALETTE     8158    // 6.50
#define IDR_ICO_SAVEPALETTE     8159    // 6.50
#define IDR_ICO_ROTATE          8160    // 6.50
#define IDR_ICO_MIRRORVERT      8161    // 6.50
#define IDR_ICO_MIRRORHORZ      8162    // 6.50
#define IDR_ICO_RESIZE          8163    // 6.50
#define IDR_ICO_NEWIMAGE        8164    // 6.50
// Dialog editor.
#define IDR_ICO_TESTDIALOG      8165    // 6.50
#define IDR_ICO_CHECKMNEMONICS  8166    // 6.50
#define IDR_ICO_LOCKCONTROLS    8167    // 6.50
#define IDR_ICO_ORDERCONTROLS   8168    // 6.50
#define IDR_ICO_ALIGNLEFT       8169    // 6.50
#define IDR_ICO_ALIGNRIGHT      8170    // 6.50
#define IDR_ICO_ALIGNTOP        8171    // 6.50
#define IDR_ICO_ALIGNBOTTOM     8172    // 6.50
#define IDR_ICO_ALIGNHORZ       8173    // 6.50
#define IDR_ICO_ALIGNVERT       8174    // 6.50
#define IDR_ICO_SPACEHORZ       8175    // 6.50
#define IDR_ICO_SPACEVERT       8176    // 6.50
#define IDR_ICO_ARRSIZEWIDTH    8177    // 6.50
#define IDR_ICO_ARRSIZEHEIGHT   8178    // 6.50
#define IDR_ICO_ARRSIZEBOTH     8179    // 6.50
#define IDR_ICO_ARRPUSHBOTTOM   8180    // 6.50
#define IDR_ICO_ARRPUSHRIGHT    8181    // 6.50
#define IDR_ICO_CENTERHORZ      8182    // 6.50
#define IDR_ICO_CENTERVERT      8183    // 6.50
// Dialog controls.
#define IDR_ICO_POINTER         8184    // 6.50
#define IDR_ICO_PICTURE         8185    // 6.50
#define IDR_ICO_STATIC          8186    // 6.50
#define IDR_ICO_EDITBOX         8187    // 6.50
#define IDR_ICO_GROUPBOX        8188    // 6.50
#define IDR_ICO_PUSHBUTTON      8189    // 6.50
#define IDR_ICO_CHECKBOX        8190    // 6.50
#define IDR_ICO_RADIOBUTTON     8191    // 6.50
#define IDR_ICO_COMBOBOX        8192    // 6.50
#define IDR_ICO_LISTBOX         8193    // 6.50
#define IDR_ICO_HSCROLLBAR      8194    // 6.50
#define IDR_ICO_VSCROLLBAR      8195    // 6.50
#define IDR_ICO_UPDOWN          8196    // 6.50
#define IDR_ICO_PROGRESS        8197    // 6.50
#define IDR_ICO_TRACKBAR        8198    // 6.50
#define IDR_ICO_HOTKEY          8199    // 6.50
#define IDR_ICO_LISTVIEW        8200    // 6.50
#define IDR_ICO_TREEVIEW        8201    // 6.50
#define IDR_ICO_TABCONTROL      8202    // 6.50
#define IDR_ICO_ANIMATE         8203    // 6.50
#define IDR_ICO_RICHEDIT        8204    // 6.50
#define IDR_ICO_RICHED20        8205    // 6.50
#define IDR_ICO_DATETIME        8206    // 6.50
#define IDR_ICO_MONTHCAL        8207    // 6.50
#define IDR_ICO_COMBOBOXEX      8208    // 6.50
#define IDR_ICO_REBAR           8209    // 6.50
#define IDR_ICO_PAGER           8210    // 6.50
#define IDR_ICO_TOOLBAR         8211    // 6.50
#define IDR_ICO_STATUSBAR       8212    // 6.50
#define IDR_ICO_SYSLINK         8213    // 6.50
#define IDR_ICO_IPADDRESS       8214    // 6.50
#define IDR_ICO_NETADDRESS      8215    // 6.50
#define IDR_ICO_SPLITBUTTON     8216    // 6.50
#define IDR_ICO_COMMANDLINK     8217    // 6.50
#define IDR_ICO_NATIVEFONT      8218    // 6.50
// Dialog properties.
#define IDR_ICO_DROPDOWN        8219    // 13.0
#define IDR_ICO_MOREEDIT        8220    // 13.0
// Menu editor.
#define IDR_ICO_TESTMENU        8221    // 6.50
// Source editor.
#define IDR_ICO_BOOKMARK        8222    // 6.50, 13.0: IDR_ICO_SETBOOKMARK -> IDR_ICO_BOOKMARK
#define IDR_ICO_NEXTBOOKMARK    8223    // 6.50
#define IDR_ICO_PREVBOOKMARK    8224    // 6.50
#define IDR_ICO_CFORMAT         8225    // 6.50
#define IDR_ICO_SPACETOTAB      8226    // 6.50
#define IDR_ICO_TABTOSPACE      8227    // 6.50
#define IDR_ICO_CARRIAGE        8228    // 13.0
#define IDR_ICO_LINEFEED        8229    // 13.0
// Difference.
#define IDR_ICO_PREVCHANGE      8230    // 7.0
#define IDR_ICO_NEXTCHANGE      8231    // 7.0
#define IDR_ICO_EXPAND          8232    // 7.0
#define IDR_ICO_COLLAPSE        8233    // 7.0
// Nothing.
#define IDR_ICO_NULL            8234    // 13.0


// Cursor ID's.
//
#define IDR_CUR_RESIZELR        8235
#define IDR_CUR_RESIZEUD        8236
#define IDR_CUR_HOTSPOT         8237
#define IDR_CUR_FLOOD           8238
#define IDR_CUR_SPRAY           8239
#define IDR_CUR_CROSS           8240
#define IDR_CUR_PENCIL          8241
#define IDR_CUR_PICKCOLOR       8242
#define IDR_CUR_MAGNIFY         8243
#define IDR_CUR_OUTSEL          8244
#define IDR_CUR_MOVE            8245
#define IDR_CUR_DROPTOOL        8246
#define IDR_CUR_DRAGMOVE        8247
#define IDR_CUR_DRAGCOPY        8248
#define IDR_CUR_NODROP          8249

// Misc ID's.
//
#define IDR_RAW_ANIFRAME        8250
#define IDR_DLL_SERVER          8251    // 4.50
#define IDR_WAV_DOH             8252
#define IDR_HTM_WELCOME         8253    // 7.0

#endif // H_IDS
